/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.validation.NoXmlHeaderValidationException;

public class ValidatorRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testValidMessageInHeader() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startHeaders", null, "headerToValidate", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessageInHeader() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startHeaders", null, "headerToValidate", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testNullHeaderNoFail() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startNullHeaderNoFail", null, "headerToValidate", null);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint});
    }

    public void testNullHeader() throws Exception {
        this.validEndpoint.setExpectedMessageCount(0);
        Exchange in = this.resolveMandatoryEndpoint("direct:startNoHeaderException").createExchange(ExchangePattern.InOut);
        in.getIn().setBody(null);
        in.getIn().setHeader("headerToValidate", null);
        Exchange out = this.template.send("direct:startNoHeaderException", in);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
        Exception exception = out.getException();
        ValidatorRouteTest.assertTrue((String)"Should be failed", (boolean)out.isFailed());
        ValidatorRouteTest.assertTrue((String)"Exception should be correct type", (boolean)(exception instanceof NoXmlHeaderValidationException));
        ValidatorRouteTest.assertTrue((String)"Exception should mention missing header", (boolean)exception.getMessage().contains("headerToValidate"));
    }

    public void testInvalideBytesMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>".getBytes());
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidBytesMessageInHeader() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startHeaders", null, "headerToValidate", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>".getBytes());
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testUseNotASharedSchema() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:useNotASharedSchema", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/schema.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:startHeaders").doTry().to("validator:org/apache/camel/component/validator/schema.xsd?headerName=headerToValidate")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
                ((RouteDefinition)this.from("direct:startNoHeaderException").to("validator:org/apache/camel/component/validator/schema.xsd?headerName=headerToValidate")).to("mock:valid");
                ((RouteDefinition)this.from("direct:startNullHeaderNoFail").to("validator:org/apache/camel/component/validator/schema.xsd?headerName=headerToValidate&failOnNullHeader=false")).to("mock:valid");
                ((RouteDefinition)this.from("direct:useNotASharedSchema").to("validator:org/apache/camel/component/validator/schema.xsd?useSharedSchema=false")).to("mock:valid");
            }
        };
    }
}

