/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;

public class SameVmQueueSizeAndNoSizeTest
extends ContextTestSupport {
    public void testSameQueue() throws Exception {
        block3: {
            for (int i = 0; i < 100; ++i) {
                this.template.sendBody("vm:foo", (Object)("" + i));
            }
            try {
                this.template.sendBody("vm:foo", (Object)"Should be full now");
                SameVmQueueSizeAndNoSizeTest.fail((String)"Should fail");
            }
            catch (CamelExecutionException e) {
                IllegalStateException ise = SameVmQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
                if (SameVmQueueSizeAndNoSizeTest.isJavaVendor("ibm")) break block3;
                SameVmQueueSizeAndNoSizeTest.assertEquals((String)"Queue full", (String)ise.getMessage());
            }
        }
    }

    public void testSameQueueDifferentSize() throws Exception {
        try {
            this.template.sendBody("vm:foo?size=200", (Object)"Should fail");
            SameVmQueueSizeAndNoSizeTest.fail((String)"Should fail");
        }
        catch (ResolveEndpointFailedException e) {
            IllegalArgumentException ise = SameVmQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            SameVmQueueSizeAndNoSizeTest.assertEquals((String)"Cannot use existing queue vm://foo as the existing queue size 100 does not match given queue size 200", (String)ise.getMessage());
        }
    }

    public void testSameQueueDifferentSizeBar() throws Exception {
        try {
            this.template.sendBody("vm:bar?size=200", (Object)"Should fail");
            SameVmQueueSizeAndNoSizeTest.fail((String)"Should fail");
        }
        catch (ResolveEndpointFailedException e) {
            IllegalArgumentException ise = SameVmQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            SameVmQueueSizeAndNoSizeTest.assertEquals((String)"Cannot use existing queue vm://bar as the existing queue size 2147483647 does not match given queue size 200", (String)ise.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:foo?size=100").routeId("foo").noAutoStartup().to("mock:foo");
                this.from("vm:bar").routeId("bar").noAutoStartup().to("mock:bar");
            }
        };
    }
}

