/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class XsltOutputFileTest
extends ContextTestSupport {
    public void testXsltOutput() throws Exception {
        XsltOutputFileTest.createDirectory("target/xslt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        mock.expectedFileExists("target/xslt/xsltme.xml");
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(File.class);
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)"target/xslt/xsltme.xml");
        this.assertMockEndpointsSatisfied();
    }

    public void testXsltOutputFileMissingHeader() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"<hello>world!</hello>");
            XsltOutputFileTest.fail((String)"Should thrown exception");
        }
        catch (CamelExecutionException e) {
            NoSuchHeaderException nshe = XsltOutputFileTest.assertIsInstanceOf(NoSuchHeaderException.class, e.getCause());
            XsltOutputFileTest.assertEquals((String)"CamelXsltFileName", (String)nshe.getHeaderName());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=file")).to("mock:result");
            }
        };
    }
}

