/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.naming.Context;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.jndi.JndiContext;

public class XsltReferenceParameterTest
extends TestSupport {
    private static final String TEST_URI_1 = "xslt:org/apache/camel/component/xslt/transform.xsl?converter=#testConverter&transformerFactory=#testTransformerFactory";
    private static final String TEST_URI_2 = "xslt:org/apache/camel/component/xslt/transform.xsl?converter=testConverter&transformerFactory=testTransformerFactory";
    private TestConverter testConverter;
    private TransformerFactory testTransformerFactory;
    private XsltBuilder builder1;
    private XsltBuilder builder2;

    public void setUp() throws Exception {
        JndiRegistry registry = new JndiRegistry((Context)new JndiContext());
        RouteBuilder builder = this.createRouteBuilder();
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        this.testConverter = new TestConverter();
        this.testTransformerFactory = TransformerFactory.newInstance();
        registry.bind("testConverter", (Object)this.testConverter);
        registry.bind("testTransformerFactory", (Object)this.testTransformerFactory);
        ProcessorEndpoint pep1 = (ProcessorEndpoint)context.getEndpoint(TEST_URI_1, ProcessorEndpoint.class);
        ProcessorEndpoint pep2 = (ProcessorEndpoint)context.getEndpoint(TEST_URI_2, ProcessorEndpoint.class);
        this.builder1 = (XsltBuilder)pep1.getProcessor();
        this.builder2 = (XsltBuilder)pep2.getProcessor();
        context.addRoutes((RoutesBuilder)builder);
        context.start();
    }

    public void testConverterReference() {
        XsltReferenceParameterTest.assertSame((Object)((Object)this.testConverter), (Object)this.builder1.getConverter());
        XsltReferenceParameterTest.assertSame((Object)((Object)this.testConverter), (Object)this.builder2.getConverter());
    }

    public void testTransformerFactoryReference() {
        XsltReferenceParameterTest.assertSame((Object)this.testTransformerFactory, (Object)this.builder1.getConverter().getTransformerFactory());
        XsltReferenceParameterTest.assertSame((Object)this.testTransformerFactory, (Object)this.builder2.getConverter().getTransformerFactory());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to(XsltReferenceParameterTest.TEST_URI_1);
                this.from("direct:b").to(XsltReferenceParameterTest.TEST_URI_2);
            }
        };
    }

    private static class TestConverter
    extends XmlConverter {
        private TestConverter() {
        }
    }
}

