/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fabric;

import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.fabric.FabricTracerEventMessage;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.DefaultManagementNamingStrategy;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.WhenDefinition;

public class FabricTracerIdOnAllNodesTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultManagementNamingStrategy naming = (DefaultManagementNamingStrategy)context.getManagementStrategy().getManagementNamingStrategy();
        naming.setHostName("localhost");
        naming.setDomainName("org.apache.camel");
        return context;
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    @Override
    protected boolean useJmx() {
        return true;
    }

    public void testFabricTracerEventMessage() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = null;
        Set<ObjectName> names = mbeanServer.queryNames(ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=fabric,*"), null);
        for (ObjectName name : names) {
            if (!name.toString().contains("FabricTracer")) continue;
            on = name;
            break;
        }
        FabricTracerIdOnAllNodesTest.assertNotNull(on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        FabricTracerIdOnAllNodesTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "QueueSize");
        FabricTracerIdOnAllNodesTest.assertEquals((String)"Should be 10", (int)10, (int)size);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:camel").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:end").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List fooExchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List camelExchanges = this.getMockEndpoint("mock:camel").getReceivedExchanges();
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        FabricTracerIdOnAllNodesTest.assertNotNull((Object)route);
        ChoiceDefinition choice = (ChoiceDefinition)route.getOutputs().get(0);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"choice1", (String)choice.getId());
        WhenDefinition when = (WhenDefinition)choice.getOutputs().get(0);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"when1", (String)when.getId());
        LogDefinition log1 = (LogDefinition)when.getOutputs().get(0);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"log1", (String)log1.getId());
        ToDefinition to1 = (ToDefinition)when.getOutputs().get(1);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"camel", (String)to1.getId());
        OtherwiseDefinition other = (OtherwiseDefinition)choice.getOutputs().get(1);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"otherwise1", (String)other.getId());
        LogDefinition log2 = (LogDefinition)other.getOutputs().get(0);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"log2", (String)log2.getId());
        ToDefinition to2 = (ToDefinition)other.getOutputs().get(1);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"to1", (String)to2.getId());
        ToDefinition to3 = (ToDefinition)other.getOutputs().get(2);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"foo", (String)to3.getId());
        ToDefinition to4 = (ToDefinition)route.getOutputs().get(1);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"end", (String)to4.getId());
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"to1"}, new String[]{"java.lang.String"});
        FabricTracerIdOnAllNodesTest.assertNotNull((Object)events);
        FabricTracerIdOnAllNodesTest.assertEquals((int)1, (int)events.size());
        FabricTracerEventMessage event1 = (FabricTracerEventMessage)events.get(0);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"to1", (String)event1.getToNode());
        FabricTracerIdOnAllNodesTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)fooExchanges.get(0)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Hello World</body>\n" + "</message>"), (String)event1.getMessageAsXml());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"camel"}, new String[]{"java.lang.String"});
        FabricTracerIdOnAllNodesTest.assertNotNull((Object)events);
        FabricTracerIdOnAllNodesTest.assertEquals((int)1, (int)events.size());
        event1 = (FabricTracerEventMessage)events.get(0);
        FabricTracerIdOnAllNodesTest.assertEquals((String)"camel", (String)event1.getToNode());
        FabricTracerIdOnAllNodesTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)camelExchanges.get(0)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Hello Camel</body>\n" + "</message>"), (String)event1.getMessageAsXml());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                FabricTracerIdOnAllNodesTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Camel")).log("A Camel message")).to("mock:camel")).id("camel")).otherwise().log("Some other kind of message")).to("mock:other")).to("mock:foo")).id("foo")).end().to("mock:end").id("end");
            }
        };
    }
}

