/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.SortedMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.InvalidPropertyException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.TestSupport;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.ParameterConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentConfigurationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentConfigurationTest.class);
    private CamelContext context;

    @Before
    public void createContext() throws Exception {
        this.context = new DefaultCamelContext();
        this.context.addComponent("cheese", (Component)new NonUriComponent());
        this.context.start();
    }

    @After
    public void destroyContext() throws Exception {
        this.context.stop();
        this.context = null;
    }

    @Test
    public void testCreateUriStringFromParameters() throws Exception {
        Component component = this.context.getComponent("seda");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        configuration.setBaseUri("foo");
        configuration.setParameter("concurrentConsumers", (Object)5);
        configuration.setParameter("size", (Object)1000);
        String uriString = configuration.getUriString();
        Assert.assertEquals((String)"uriString", (Object)"foo?concurrentConsumers=5&size=1000", (Object)uriString);
    }

    @Test
    public void testCreateUriStringFromParametersOnDefaultComponent() throws Exception {
        Component component = this.context.getComponent("cheese");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        configuration.setBaseUri("somePath");
        configuration.setParameter("foo", (Object)"something");
        configuration.setParameter("bar", (Object)123);
        String uriString = configuration.getUriString();
        Assert.assertEquals((String)"uriString", (Object)"somePath?bar=123&foo=something", (Object)uriString);
    }

    @Test
    public void testSetParametersFromUriString() throws Exception {
        Component component = this.context.getComponent("seda");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        configuration.setUriString("foo?concurrentConsumers=5&size=1000");
        Assert.assertEquals((String)"concurrentConsumers", (Object)5, (Object)configuration.getParameter("concurrentConsumers"));
        Assert.assertEquals((String)"size", (Object)1000, (Object)configuration.getParameter("size"));
        configuration.setUriString("foo?concurrentConsumers=9&size=2000");
        Assert.assertEquals((String)"concurrentConsumers", (Object)9, (Object)configuration.getParameter("concurrentConsumers"));
        Assert.assertEquals((String)"size", (Object)2000, (Object)configuration.getParameter("size"));
    }

    @Test
    public void testSetParametersFromUriStringOnDefaultComponent() throws Exception {
        Component component = this.context.getComponent("cheese");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        configuration.setUriString("somePath?foo=something&bar=123");
        Assert.assertEquals((String)"foo", (Object)"something", (Object)configuration.getParameter("foo"));
        Assert.assertEquals((String)"bar", (Object)"123", (Object)configuration.getParameter("bar"));
        configuration.setUriString("somePath?foo=another&bar=456");
        Assert.assertEquals((String)"foo", (Object)"another", (Object)configuration.getParameter("foo"));
        Assert.assertEquals((String)"bar", (Object)"456", (Object)configuration.getParameter("bar"));
    }

    @Test
    public void testCreateNewSedaUriEndpoint() throws Exception {
        Component component = this.context.getComponent("seda");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        configuration.setBaseUri("foo");
        configuration.setParameter("concurrentConsumers", (Object)5);
        configuration.setParameter("size", (Object)1000);
        try {
            configuration.setParameter("doesNotExist", (Object)1000);
            Assert.fail((String)"Should have got InvalidPropertyException thrown!");
        }
        catch (InvalidPropertyException e) {
            LOG.info("Got expected exception: " + (Object)((Object)e));
        }
        SedaEndpoint endpoint = TestSupport.assertIsInstanceOf(SedaEndpoint.class, configuration.createEndpoint());
        Assert.assertEquals((String)"concurrentConsumers", (long)5L, (long)endpoint.getConcurrentConsumers());
        Assert.assertEquals((String)"size", (long)1000L, (long)endpoint.getSize());
        Assert.assertEquals((String)"endpoint uri", (Object)"foo?concurrentConsumers=5&size=1000", (Object)endpoint.getEndpointUri());
        configuration.setEndpointParameter((Endpoint)endpoint, "concurrentConsumers", (Object)6);
        Assert.assertEquals((String)"concurrentConsumers", (long)6L, (long)endpoint.getConcurrentConsumers());
        try {
            configuration.setEndpointParameter((Endpoint)endpoint, "doesNotExist", (Object)1000);
            Assert.fail((String)"Should have got InvalidPropertyException thrown!");
        }
        catch (InvalidPropertyException e) {
            LOG.info("Got expected exception: " + (Object)((Object)e));
        }
    }

    @Test
    public void testCreateNewDefaultComponentEndpoint() throws Exception {
        Component component = this.context.getComponent("cheese");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        configuration.setBaseUri("something");
        configuration.setParameter("foo", (Object)"xyz");
        configuration.setParameter("bar", (Object)5);
        NonUriEndpoint endpoint = TestSupport.assertIsInstanceOf(NonUriEndpoint.class, configuration.createEndpoint());
        Assert.assertEquals((String)"foo", (Object)"xyz", (Object)endpoint.getFoo());
        Assert.assertEquals((String)"bar", (long)5L, (long)endpoint.getBar());
        LOG.info("Created endpoint " + (Object)((Object)endpoint) + " on URI " + endpoint.getEndpointUri());
        configuration.setEndpointParameter((Endpoint)endpoint, "bar", (Object)6);
        Assert.assertEquals((String)"bar", (long)6L, (long)endpoint.getBar());
        try {
            configuration.setEndpointParameter((Endpoint)endpoint, "doesNotExist", (Object)1000);
            Assert.fail((String)"Should have got InvalidPropertyException thrown!");
        }
        catch (InvalidPropertyException e) {
            LOG.info("Got expected exception: " + (Object)((Object)e));
        }
        ComponentConfiguration badConfiguration = component.createComponentConfiguration();
        badConfiguration.setBaseUri(configuration.getBaseUri());
        badConfiguration.setParameters(configuration.getParameters());
        badConfiguration.setParameter("doesNotExist", (Object)1000);
        try {
            badConfiguration.createEndpoint();
            Assert.fail((String)"Should have got ResolveEndpointFailedException thrown!");
        }
        catch (ResolveEndpointFailedException e) {
            LOG.info("Got expected exception: " + (Object)((Object)e));
        }
    }

    @Test
    public void testIntrospectSedaEndpointParameters() throws Exception {
        Component component = this.context.getComponent("seda");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        SortedMap parameterMap = configuration.getParameterConfigurationMap();
        Assert.assertTrue((String)"getParameterConfigurationMap() should not be empty!", (!parameterMap.isEmpty() ? 1 : 0) != 0);
        ParameterConfiguration concurrentConsumersConfig = (ParameterConfiguration)parameterMap.get("concurrentConsumers");
        Assert.assertNotNull((String)"parameterMap[concurrentConsumers] should not be null!", (Object)concurrentConsumersConfig);
        Assert.assertEquals((String)"concurrentConsumersConfig.getName()", (Object)"concurrentConsumers", (Object)concurrentConsumersConfig.getName());
        Assert.assertEquals((String)"concurrentConsumersConfig.getParameterType()", Integer.TYPE, (Object)concurrentConsumersConfig.getParameterType());
        LOG.info("{} has has configuration properties {}", (Object)component, parameterMap.keySet());
    }

    @Test
    public void testIntrospectDefaultComponentParameters() throws Exception {
        Component component = this.context.getComponent("cheese");
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertNotNull((String)("Should have created a ComponentConfiguration for component " + component), (Object)configuration);
        SortedMap parameterMap = configuration.getParameterConfigurationMap();
        Assert.assertTrue((String)"getParameterConfigurationMap() should be empty as we have no parameters yet", (boolean)parameterMap.isEmpty());
        configuration.setUriString("somePath?foo=something&bar=123");
        parameterMap = configuration.getParameterConfigurationMap();
        Assert.assertEquals((String)"getParameterConfigurationMap() size", (long)2L, (long)parameterMap.size());
        ParameterConfiguration barConfiguration = configuration.getParameterConfiguration("bar");
        Assert.assertNotNull((String)"should hav a configuration for 'bar'", (Object)barConfiguration);
        Assert.assertEquals((String)"barConfiguration.getName()", (Object)"bar", (Object)barConfiguration.getName());
        Assert.assertEquals((String)"barConfiguration.getParameterType()", String.class, (Object)barConfiguration.getParameterType());
    }

    @Test
    public void testConfigureAnExistingSedaEndpoint() throws Exception {
        SedaEndpoint endpoint = (SedaEndpoint)this.context.getEndpoint("seda:cheese?concurrentConsumers=5", SedaEndpoint.class);
        SedaComponent component = endpoint.getComponent();
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertEquals((String)"concurrentConsumers", (long)5L, (long)endpoint.getConcurrentConsumers());
        Assert.assertEquals((String)"concurrentConsumers", (Object)5, (Object)configuration.getEndpointParameter((Endpoint)endpoint, "concurrentConsumers"));
        configuration.setEndpointParameter((Endpoint)endpoint, "concurrentConsumers", (Object)10);
        Object concurrentConsumers = configuration.getEndpointParameter((Endpoint)endpoint, "concurrentConsumers");
        Assert.assertEquals((String)"endpoint.concurrentConsumers", (Object)10, (Object)concurrentConsumers);
        configuration.setEndpointParameter((Endpoint)endpoint, "size", (Object)1000);
        Object size = configuration.getEndpointParameter((Endpoint)endpoint, "size");
        Assert.assertEquals((String)"endpoint.size", (Object)1000, (Object)size);
        try {
            configuration.setEndpointParameter((Endpoint)endpoint, "doesNotExist", (Object)1000);
            Assert.fail((String)"Should have got InvalidPropertyException thrown!");
        }
        catch (InvalidPropertyException e) {
            LOG.info("Got expected exception: " + (Object)((Object)e));
        }
    }

    @Test
    public void testConfigureAnExistingDefaultEndpoint() throws Exception {
        NonUriEndpoint endpoint = (NonUriEndpoint)this.context.getEndpoint("cheese:somePath?bar=123&foo=something", NonUriEndpoint.class);
        Component component = endpoint.getComponent();
        ComponentConfiguration configuration = component.createComponentConfiguration();
        Assert.assertEquals((String)"bar", (long)123L, (long)endpoint.getBar());
        Assert.assertEquals((String)"bar", (Object)123, (Object)configuration.getEndpointParameter((Endpoint)endpoint, "bar"));
        configuration.setEndpointParameter((Endpoint)endpoint, "bar", (Object)10);
        Object bar = configuration.getEndpointParameter((Endpoint)endpoint, "bar");
        Assert.assertEquals((String)"endpoint.bar", (Object)10, (Object)bar);
        configuration.setEndpointParameter((Endpoint)endpoint, "foo", (Object)"anotherThing");
        Object foo = configuration.getEndpointParameter((Endpoint)endpoint, "foo");
        Assert.assertEquals((String)"endpoint.foo", (Object)"anotherThing", (Object)foo);
        try {
            configuration.setEndpointParameter((Endpoint)endpoint, "doesNotExist", (Object)1000);
            Assert.fail((String)"Should have got InvalidPropertyException thrown!");
        }
        catch (InvalidPropertyException e) {
            LOG.info("Got expected exception: " + (Object)((Object)e));
        }
    }

    public static class NonUriEndpoint
    extends DefaultEndpoint {
        private String foo;
        private int bar;

        public NonUriEndpoint(String uri, NonUriComponent component) {
            super(uri, (Component)component);
        }

        public int getBar() {
            return this.bar;
        }

        public void setBar(int bar) {
            this.bar = bar;
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }
    }

    public static class NonUriComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new NonUriEndpoint(uri, this);
        }
    }
}

