/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.DefaultThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolFactory;

public class CustomThreadPoolFactoryTest
extends ContextTestSupport {
    private MyCustomThreadPoolFactory factory = new MyCustomThreadPoolFactory();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getExecutorServiceManager().setThreadPoolFactory((ThreadPoolFactory)this.factory);
        return context;
    }

    public void testCustomThreadPoolFactory() {
        this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "foo");
        CustomThreadPoolFactoryTest.assertTrue((String)"Should use custom thread pool factory", (boolean)this.factory.isInvoked());
    }

    public static final class MyCustomThreadPoolFactory
    extends DefaultThreadPoolFactory {
        private volatile boolean invoked;

        public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
            this.invoked = true;
            return super.newCachedThreadPool(threadFactory);
        }

        public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
            this.invoked = true;
            return super.newThreadPool(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, rejectedExecutionHandler, threadFactory);
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }
}

