/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.JndiRegistry;

public class DefaultComponentReferencePropertiesTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myExpression", (Object)ExpressionBuilder.bodyExpression());
        return jndi;
    }

    public void testEmptyPath() throws Exception {
        DefaultComponent component = new DefaultComponent((CamelContext)this.context){

            protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
                TestCase.assertEquals((String)"foo://?name=Christian", (String)uri);
                TestCase.assertEquals((String)"", (String)remaining);
                TestCase.assertEquals((int)1, (int)parameters.size());
                TestCase.assertEquals((Object)"Christian", (Object)parameters.get("name"));
                return null;
            }
        };
        component.createEndpoint("foo://?name=Christian");
    }

    public void testOnlyStringSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?name=Claus");
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)((Object)endpoint));
        DefaultComponentReferencePropertiesTest.assertEquals((String)"Claus", (String)endpoint.name);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.expression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.stringExpression);
    }

    public void testCallStringSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?expression=hello");
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)((Object)endpoint));
        DefaultComponentReferencePropertiesTest.assertEquals((String)"hello", (String)endpoint.stringExpression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.expression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.name);
    }

    public void testNoBeanInRegistryThenCallStringSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?expression=#hello");
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)((Object)endpoint));
        DefaultComponentReferencePropertiesTest.assertEquals((String)"#hello", (String)endpoint.stringExpression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.expression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.name);
    }

    public void testCallExpressionSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?expression=#myExpression");
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)((Object)endpoint));
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.stringExpression);
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)endpoint.expression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.name);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        DefaultComponentReferencePropertiesTest.assertEquals((String)"Hello World", (String)((String)endpoint.expression.evaluate((Exchange)exchange, String.class)));
    }

    public void testCallSingleExpressionSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?special=#myExpression");
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)((Object)endpoint));
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.stringExpression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.expression);
        DefaultComponentReferencePropertiesTest.assertNull((Object)endpoint.name);
        DefaultComponentReferencePropertiesTest.assertNotNull((Object)endpoint.special);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        DefaultComponentReferencePropertiesTest.assertEquals((String)"Hello World", (String)((String)endpoint.special.evaluate((Exchange)exchange, String.class)));
    }

    public void testTypoInParameter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        try {
            component.createEndpoint("foo://?xxxexpression=#hello");
            DefaultComponentReferencePropertiesTest.fail((String)"Should have throw a ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    public void testTypoInParameterValue() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        try {
            component.createEndpoint("foo://?special=#dummy");
            DefaultComponentReferencePropertiesTest.fail((String)"Should have throw a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final class MyComponent
    extends DefaultComponent {
        private MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            MyEndpoint result = new MyEndpoint(uri, (Component)this);
            this.setProperties((Object)result, parameters);
            return result;
        }
    }

    public final class MyEndpoint
    extends DefaultEndpoint {
        private Expression expression;
        private String stringExpression;
        private String name;
        private Expression special;

        private MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public boolean isSingleton() {
            return true;
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public void setExpression(List<?> expressions) {
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        public void setExpression(String expression) {
            this.stringExpression = expression;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSpecial(Expression special) {
            this.special = special;
        }
    }
}

