/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;

public class DefaultComponentValidateURITest
extends ContextTestSupport {
    public void testNoParameters() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("timer://foo");
        DefaultComponentValidateURITest.assertNotNull((String)"Should have created an endpoint", (Object)endpoint);
    }

    public void testNoQuestionMarker() throws Exception {
        try {
            this.context.getEndpoint("timer://foo&fixedRate=true&delay=0&period=500");
            DefaultComponentValidateURITest.fail((String)"Should have thrown ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    public void testUnknownParameter() throws Exception {
        try {
            this.context.getEndpoint("timer://foo?delay=250&unknown=1&period=500");
            DefaultComponentValidateURITest.fail((String)"Should have thrown ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    public void testDoubleAmpersand() throws Exception {
        try {
            this.context.getEndpoint("timer://foo?delay=250&&period=500");
            DefaultComponentValidateURITest.fail((String)"Should have thrown ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    public void testTrailingAmpersand() throws Exception {
        try {
            this.context.getEndpoint("timer://foo?delay=250&period=500&");
            DefaultComponentValidateURITest.fail((String)"Should have thrown ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    public void testScheduledPollConsumerOptions() throws Exception {
        Endpoint endpint = this.context.getEndpoint("file://target/foo?consumer.delay=1000");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://target/foo?consumer.delay=1000&consumer.initialDelay=5000");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://target/foo?consumer.delay=1000&consumer.initialDelay=5000&consumer.useFixedDelay=false");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://foo2?delay=1000");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://foo2?delay=1000&initialDelay=5000");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://foo2?delay=1000&initialDelay=5000&useFixedDelay=false");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://foo3?delay=1000&consumer.initialDelay=5000&useFixedDelay=false");
        DefaultComponentValidateURITest.assertNotNull((Object)endpint);
    }
}

