/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.model.RouteDefinition;

public class DefaultProducerTemplateTest
extends ContextTestSupport {
    public void testIn() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        Object result = this.template.requestBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateTest.assertEquals((Object)"Bye World", (Object)result);
        DefaultProducerTemplateTest.assertSame((Object)this.context, (Object)this.template.getCamelContext());
    }

    public void testInOut() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Bye World"});
        Object result = this.template.requestBody("direct:out", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateTest.assertEquals((Object)"Bye Bye World", (Object)result);
    }

    public void testFault() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Object result = this.template.requestBody("direct:fault", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateTest.assertEquals((Object)"Faulty World", (Object)result);
    }

    public void testExceptionUsingBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:exception", (Object)"Hello World");
            DefaultProducerTemplateTest.fail((String)"Should have thrown RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            DefaultProducerTemplateTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            DefaultProducerTemplateTest.assertEquals((String)"Forced exception by unit test", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testExceptionUsingProcessor() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = this.template.send("direct:exception", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        DefaultProducerTemplateTest.assertTrue((boolean)out.isFailed());
        DefaultProducerTemplateTest.assertEquals((String)"Forced exception by unit test", (String)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    public void testExceptionUsingExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange exchange = this.context.getEndpoint("direct:exception").createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        Exchange out = this.template.send("direct:exception", exchange);
        DefaultProducerTemplateTest.assertTrue((boolean)out.isFailed());
        DefaultProducerTemplateTest.assertEquals((String)"Forced exception by unit test", (String)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    public void testRequestExceptionUsingBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:exception", (Object)"Hello World");
            DefaultProducerTemplateTest.fail((String)"Should have thrown RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            DefaultProducerTemplateTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            DefaultProducerTemplateTest.assertEquals((String)"Forced exception by unit test", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testRequestExceptionUsingProcessor() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = this.template.request("direct:exception", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        DefaultProducerTemplateTest.assertTrue((boolean)out.isFailed());
        DefaultProducerTemplateTest.assertEquals((String)"Forced exception by unit test", (String)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    public void testRequestExceptionUsingExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange exchange = this.context.getEndpoint("direct:exception").createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"Hello World");
        Exchange out = this.template.send("direct:exception", exchange);
        DefaultProducerTemplateTest.assertTrue((boolean)out.isFailed());
        DefaultProducerTemplateTest.assertEquals((String)"Forced exception by unit test", (String)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    public void testRequestBody() throws Exception {
        Integer out = (Integer)this.template.requestBody("direct:inout", (Object)"Hello", Integer.class);
        DefaultProducerTemplateTest.assertEquals((Object)new Integer(123), (Object)out);
        out = (Integer)this.template.requestBodyAndHeader("direct:inout", (Object)"Hello", "foo", (Object)"bar", Integer.class);
        DefaultProducerTemplateTest.assertEquals((Object)new Integer(123), (Object)out);
        HashMap headers = new HashMap();
        out = (Integer)this.template.requestBodyAndHeaders("direct:inout", (Object)"Hello", headers, Integer.class);
        DefaultProducerTemplateTest.assertEquals((Object)new Integer(123), (Object)out);
        Endpoint endpoint = this.context.getEndpoint("direct:inout");
        out = (Integer)this.template.requestBody(endpoint, (Object)"Hello", Integer.class);
        DefaultProducerTemplateTest.assertEquals((Object)new Integer(123), (Object)out);
        out = (Integer)this.template.requestBodyAndHeader(endpoint, (Object)"Hello", "foo", (Object)"bar", Integer.class);
        DefaultProducerTemplateTest.assertEquals((Object)new Integer(123), (Object)out);
        headers = new HashMap();
        out = (Integer)this.template.requestBodyAndHeaders(endpoint, (Object)"Hello", headers, Integer.class);
        DefaultProducerTemplateTest.assertEquals((Object)new Integer(123), (Object)out);
    }

    public void testRequestUsingDefaultEndpoint() throws Exception {
        DefaultProducerTemplate producer = new DefaultProducerTemplate((CamelContext)this.context, this.context.getEndpoint("direct:out"));
        producer.start();
        Object out = producer.requestBody((Object)"Hello");
        DefaultProducerTemplateTest.assertEquals((Object)"Bye Bye World", (Object)out);
        out = producer.requestBodyAndHeader((Object)"Hello", "foo", (Object)123);
        DefaultProducerTemplateTest.assertEquals((Object)"Bye Bye World", (Object)out);
        HashMap headers = new HashMap();
        out = producer.requestBodyAndHeaders((Object)"Hello", headers);
        DefaultProducerTemplateTest.assertEquals((Object)"Bye Bye World", (Object)out);
        producer.stop();
    }

    public void testSendUsingDefaultEndpoint() throws Exception {
        DefaultProducerTemplate producer = new DefaultProducerTemplate((CamelContext)this.context, this.context.getEndpoint("direct:in"));
        producer.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        producer.sendBody((Object)"Hello");
        producer.sendBodyAndHeader((Object)"Hello", "foo", (Object)123);
        HashMap headers = new HashMap();
        producer.sendBodyAndHeaders((Object)"Hello", headers);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((RouteDefinition)this.from("direct:in").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:out").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setBody((Object)"Bye Bye World");
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:fault").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setFault(true);
                        exchange.getOut().setBody((Object)"Faulty World");
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:exception").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced exception by unit test");
                    }
                })).to("mock:result");
                this.from("direct:inout").transform((Expression)this.constant(123));
            }
        };
    }

    public void testCacheProducers() throws Exception {
        DefaultProducerTemplate template = new DefaultProducerTemplate((CamelContext)this.context);
        template.setMaximumCacheSize(500);
        template.start();
        DefaultProducerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("seda:queue:" + i);
            template.sendBody(e, (Object)"Hello");
        }
        DefaultProducerTemplateTest.assertEquals((String)"Size should be 500", (int)500, (int)template.getCurrentCacheSize());
        template.stop();
        DefaultProducerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
    }

    public void testCacheProducersFromContext() throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate(500);
        DefaultProducerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("seda:queue:" + i);
            template.sendBody(e, (Object)"Hello");
        }
        DefaultProducerTemplateTest.assertEquals((String)"Size should be 500", (int)500, (int)template.getCurrentCacheSize());
        template.stop();
        DefaultProducerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
    }
}

