/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.support.ExpressionSupport;

public class ExpressionSupportTest
extends ContextTestSupport {
    public void testExpressionSupport() throws Exception {
        MyExpression my = new MyExpression();
        DefaultExchange e = new DefaultExchange((CamelContext)this.context);
        e.getIn().setBody((Object)"bar");
        my.assertMatches("bar", (Exchange)e);
    }

    public void testExpressionSupportFail() throws Exception {
        MyExpression my = new MyExpression();
        DefaultExchange e = new DefaultExchange((CamelContext)this.context);
        e.getIn().setBody((Object)"Kabom");
        try {
            my.assertMatches("damn", (Exchange)e);
            ExpressionSupportTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError ae) {
            ExpressionSupportTest.assertTrue((boolean)((Throwable)((Object)ae)).getMessage().contains("foo"));
        }
    }

    private static class MyExpression
    extends ExpressionSupport {
        private MyExpression() {
        }

        protected String assertionFailureMessage(Exchange exchange) {
            return "foo";
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String in = (String)exchange.getIn().getBody(String.class);
            if ("Kabom".equals(in)) {
                return null;
            }
            return (T)in;
        }
    }
}

