/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FromMultipleEndpointTest
extends ContextTestSupport {
    public void testMultipleFromEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:results");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:foo", (Object)"foo");
        this.template.sendBody("seda:bar", (Object)"bar");
        mock.assertIsSatisfied();
        List list = mock.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Endpoint fromEndpoint = exchange.getFromEndpoint();
        FromMultipleEndpointTest.assertEquals((String)"fromEndpoint URI", (String)"direct://foo", (String)fromEndpoint.getEndpointUri());
        exchange = (Exchange)list.get(1);
        fromEndpoint = exchange.getFromEndpoint();
        FromMultipleEndpointTest.assertEquals((String)"fromEndpoint URI", (String)"seda://bar", (String)fromEndpoint.getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().setTracing(Boolean.valueOf(true));
                this.from(new String[]{"direct:foo", "seda:bar"}).to("mock:results");
            }
        };
    }
}

