/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class GracefulShutdownNoAutoStartOrderClashTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testStartupOrderClash() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").startupOrder(5).to("mock:foo");
                this.from("direct:bar").routeId("bar").startupOrder(5).noAutoStartup().to("mock:bar");
            }
        });
        try {
            this.context.start();
            GracefulShutdownNoAutoStartOrderClashTest.fail((String)"Should have thrown an exception");
        }
        catch (FailedToStartRouteException e) {
            GracefulShutdownNoAutoStartOrderClashTest.assertEquals((String)"Failed to start route bar because of startupOrder clash. Route foo already has startupOrder 5 configured which this route have as well. Please correct startupOrder to be unique among all your routes.", (String)e.getMessage());
        }
    }
}

