/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.SimpleUuidGenerator;
import org.apache.camel.spi.UuidGenerator;

public class MessageSupportTest
extends ContextTestSupport {
    public void testSetBodyType() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        in.setBody((Object)"123", Integer.class);
        MessageSupportTest.assertIsInstanceOf(Integer.class, in.getBody());
    }

    public void testGetMandatoryBody() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        try {
            in.getMandatoryBody();
            MessageSupportTest.fail((String)"Should have thrown an exception");
        }
        catch (InvalidPayloadException invalidPayloadException) {
            // empty catch block
        }
        in.setBody((Object)"Hello World");
        MessageSupportTest.assertEquals((Object)"Hello World", (Object)in.getMandatoryBody());
    }

    public void testGetMessageId() {
        this.context.setUuidGenerator((UuidGenerator)new SimpleUuidGenerator());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        MessageSupportTest.assertEquals((String)"1", (String)in.getMessageId());
    }

    public void testGetMessageIdWithoutAnExchange() {
        DefaultMessage in = new DefaultMessage();
        MessageSupportTest.assertNotNull((Object)in.getMessageId());
    }

    public void testCopyFromSameHeadersInstance() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        Map headers = in.getHeaders();
        headers.put("foo", 123);
        DefaultMessage out = new DefaultMessage();
        out.setBody((Object)"Bye World");
        out.setHeaders(headers);
        out.copyFrom(in);
        MessageSupportTest.assertEquals((Object)123, headers.get("foo"));
        MessageSupportTest.assertEquals((Object)123, (Object)in.getHeader("foo"));
        MessageSupportTest.assertEquals((Object)123, (Object)out.getHeader("foo"));
    }
}

