/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultRoute;
import org.apache.camel.model.RouteDefinition;

public class RouteRemoveTest
extends ContextTestSupport {
    public void testStopRouteOnContext() throws Exception {
        RouteRemoveTest.assertEquals((Object)ServiceStatus.Started, (Object)((DefaultRoute)this.context.getRoute("foo")).getStatus());
        RouteRemoveTest.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteStatus("foo"));
        this.context.stopRoute("foo");
        RouteRemoveTest.assertEquals((Object)ServiceStatus.Stopped, (Object)((DefaultRoute)this.context.getRoute("foo")).getStatus());
        RouteRemoveTest.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteStatus("foo"));
    }

    public void testRemove() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        RouteRemoveTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
        RouteRemoveTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        boolean removed = this.context.removeRoute("foo");
        RouteRemoveTest.assertFalse((boolean)removed);
        RouteRemoveTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        RouteRemoveTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
        this.context.stopRoute("foo");
        removed = this.context.removeRoute("foo");
        RouteRemoveTest.assertTrue((boolean)removed);
        RouteRemoveTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        RouteRemoveTest.assertNull((Object)this.context.getRouteStatus("foo"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

