/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.impl.ScheduledPollEndpoint;

public class ScheduledPollEndpointConfigureConsumerRestartTest
extends ContextTestSupport {
    private MyEndpoint my;
    private Map<String, Object> props = new HashMap<String, Object>();

    public void testRestart() throws Exception {
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        ScheduledPollEndpointConfigureConsumerRestartTest.assertEquals((Object)"Hello", (Object)((Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0)).getIn().getBody());
        ScheduledPollEndpointConfigureConsumerRestartTest.assertEquals((Object)123, (Object)((Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0)).getIn().getHeader("foo"));
        this.resetMocks();
        this.context.stopRoute("foo");
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(1);
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        ScheduledPollEndpointConfigureConsumerRestartTest.assertEquals((Object)"Hello", (Object)((Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0)).getIn().getBody());
        ScheduledPollEndpointConfigureConsumerRestartTest.assertEquals((Object)123, (Object)((Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0)).getIn().getHeader("foo"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ScheduledPollEndpointConfigureConsumerRestartTest.this.props.put("foo", 123);
                ScheduledPollEndpointConfigureConsumerRestartTest.this.props.put("bar", "Hello");
                ScheduledPollEndpointConfigureConsumerRestartTest.this.props.put("delay", 1000);
                ScheduledPollEndpointConfigureConsumerRestartTest.this.my = new MyEndpoint();
                ScheduledPollEndpointConfigureConsumerRestartTest.this.my.setCamelContext((CamelContext)ScheduledPollEndpointConfigureConsumerRestartTest.this.context);
                ScheduledPollEndpointConfigureConsumerRestartTest.this.my.setConsumerProperties(ScheduledPollEndpointConfigureConsumerRestartTest.this.props);
                this.from((Endpoint)ScheduledPollEndpointConfigureConsumerRestartTest.this.my).routeId("foo").to("mock:result");
            }
        };
    }

    public static final class MyConsumer
    extends ScheduledPollConsumer {
        private int foo;
        private String bar;

        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        public int getFoo() {
            return this.foo;
        }

        public void setFoo(int foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        protected int poll() throws Exception {
            DefaultExchange exchange = new DefaultExchange(this.getEndpoint());
            exchange.getIn().setBody((Object)this.bar);
            exchange.getIn().setHeader("foo", (Object)this.foo);
            this.getProcessor().process((Exchange)exchange);
            return 1;
        }
    }

    private static class MyEndpoint
    extends ScheduledPollEndpoint {
        private MyEndpoint() {
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            MyConsumer answer = new MyConsumer((Endpoint)this, processor);
            this.configureConsumer((Consumer)answer);
            return answer;
        }

        public boolean isSingleton() {
            return true;
        }

        protected String createEndpointUri() {
            return "myendpoint:foo";
        }
    }
}

