/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.TypeConverterSupport;

public class TypeConverterRegistryMissesThenAddTest
extends TestCase {
    public void testMissThenAddTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        MyOrder order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        TypeConverterRegistryMissesThenAddTest.assertNull((Object)order);
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        TypeConverterRegistryMissesThenAddTest.assertNotNull((Object)order);
        TypeConverterRegistryMissesThenAddTest.assertEquals((int)123, (int)order.getId());
    }

    private static class MyOrderTypeConverter
    extends TypeConverterSupport {
        private MyOrderTypeConverter() {
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
            MyOrder order = new MyOrder();
            order.setId(Integer.parseInt(value.toString()));
            return (T)order;
        }
    }

    private static class MyOrder {
        private int id;

        private MyOrder() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

