/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.model.RouteDefinition;

public class EndpointWithRawUriParameterTest
extends ContextTestSupport {
    public void testRawUriParameter() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("username", (Object)"scott");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("password", (Object)"++%%w?rd");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                EndpointWithRawUriParameterTest.this.context.addComponent("mycomponent", (Component)new MyComponent());
                ((RouteDefinition)this.from("direct:start").to("mycomponent:foo?password=RAW(++%%w?rd)&username=scott")).to("mock:result");
            }
        };
    }

    public final class MyEndpoint
    extends DefaultEndpoint {
        private String username;
        private String password;

        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() throws Exception {
            return new DefaultProducer((Endpoint)this){

                public void process(Exchange exchange) throws Exception {
                    exchange.getIn().setHeader("username", (Object)MyEndpoint.this.getUsername());
                    exchange.getIn().setHeader("password", (Object)MyEndpoint.this.getPassword());
                }
            };
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public final class MyComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            MyEndpoint answer = new MyEndpoint(uri, (Component)this);
            this.setProperties((Object)answer, parameters);
            return answer;
        }
    }
}

