/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class ExceptionCamel4022Test
extends ContextTestSupport {
    public void testExceptionWithFatalException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:intermediate").expectedMessageCount(0);
        this.getMockEndpoint("mock:onexception").expectedMessageCount(0);
        this.getMockEndpoint("mock:dlc").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"<body/>");
            ExceptionCamel4022Test.fail((String)"Should throw an exception");
        }
        catch (Exception e) {
            IllegalArgumentException cause = ExceptionCamel4022Test.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ExceptionCamel4022Test.assertEquals((String)"Damn Again", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dlc").redeliveryDelay(0L).maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(Exception.class).logStackTrace(false).process((Processor)new MyExceptionThrower("Damn Again"))).to("mock:onexception");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).to("direct:intermediate")).to("mock:result2");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:b")).setBody((Expression)this.constant("<some-value/>"))).process((Processor)new MyExceptionThrower("Damn"))).to("mock:intermediate");
            }
        };
    }

    public static class MyExceptionThrower
    implements Processor {
        private String msg;

        public MyExceptionThrower(String msg) {
            this.msg = msg;
        }

        public void process(Exchange exchange) throws Exception {
            throw new IllegalArgumentException(this.msg);
        }
    }
}

