/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RouteScopedOnExceptionWithInterceptSendToEndpointIssueWithPredicateTest
extends ContextTestSupport {
    private final AtomicInteger invoked = new AtomicInteger();

    public void testIssue() throws Exception {
        final Predicate fail = PredicateBuilder.or((Predicate)RouteScopedOnExceptionWithInterceptSendToEndpointIssueWithPredicateTest.header("CamelRedeliveryCounter").isNull(), (Predicate)RouteScopedOnExceptionWithInterceptSendToEndpointIssueWithPredicateTest.header("CamelRedeliveryCounter").isLessThan((Object)5));
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        route.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RouteScopedOnExceptionWithInterceptSendToEndpointIssueWithPredicateTest.this.invoked.incrementAndGet();
                        if (fail.matches(exchange)) {
                            throw new ConnectException("Forced");
                        }
                    }
                })).to("mock:ok");
            }
        });
        this.getMockEndpoint("mock:global").expectedMessageCount(0);
        this.getMockEndpoint("mock:ok").expectedMessageCount(1);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RouteScopedOnExceptionWithInterceptSendToEndpointIssueWithPredicateTest.assertEquals((int)6, (int)this.invoked.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:global").maximumRedeliveries(2).redeliveryDelay(5000L));
                ((OnExceptionDefinition)this.from("direct:start").onException(ConnectException.class).maximumRedeliveries(5).redeliveryDelay(0L).logRetryAttempted(true).retryAttemptedLogLevel(LoggingLevel.WARN).to("mock:exhausted")).end().to("seda:foo");
            }
        };
    }
}

