/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.TryDefinition;

public class SetHeaderInDoCatchIssueTest
extends ContextTestSupport {
    public void testSuccess() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        SetHeaderInDoCatchIssueTest.assertEquals((Object)"CamsResponse", (Object)exchange.getOut().getHeader("Status"));
    }

    public void testExchangeTimedOutException() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"ExchangeTimedOutException");
            }
        });
        SetHeaderInDoCatchIssueTest.assertEquals((Object)"TimeOut", (Object)exchange.getOut().getHeader("Status"));
    }

    public void testException() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Exception");
            }
        });
        SetHeaderInDoCatchIssueTest.assertEquals((Object)"ExceptionGeneral", (Object)exchange.getOut().getHeader("Status"));
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = new JndiRegistry(this.createJndiContext());
        registry.bind("A", (Object)new Processor(){

            public void process(Exchange exchange) throws Exception {
                SetHeaderInDoCatchIssueTest.this.log.info("A headers " + exchange.getIn().getHeaders());
            }
        });
        registry.bind("B", (Object)new Processor(){

            public void process(Exchange exchange) throws Exception {
                SetHeaderInDoCatchIssueTest.this.log.info("B headers " + exchange.getIn().getHeaders());
                if ("ExchangeTimedOutException".equals(exchange.getIn().getBody(String.class))) {
                    throw new ExchangeTimedOutException(exchange, 1L);
                }
                if ("Exception".equals(exchange.getIn().getBody(String.class))) {
                    throw new Exception();
                }
            }
        });
        registry.bind("C", (Object)new Processor(){

            public void process(Exchange exchange) throws Exception {
                SetHeaderInDoCatchIssueTest.this.log.info("C headers " + exchange.getIn().getHeaders());
            }
        });
        return registry;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SetHeaderInDoCatchIssueTest.this.context.setTracing(Boolean.valueOf(true));
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("A")).setHeader("CamelJmsDestinationName", (Expression)this.constant("queue:outQueue"))).inOut("B")).setHeader("Status", (Expression)this.constant("CamsResponse"))).doCatch(ExchangeTimedOutException.class).setHeader("Status", (Expression)this.constant("TimeOut"))).doCatch(Exception.class).setHeader("Status", (Expression)this.constant("ExceptionGeneral"))).end().to("C").transform((Expression)this.body());
            }
        };
    }
}

