/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.TryDefinition;

public class TryCatchWithSplitNotHandledIssueTest
extends ContextTestSupport {
    public void testSplitWithErrorIsNotHandled() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"James"});
        ((ValueBuilder)error.message(0).property("CamelExceptionCaught")).isNotNull();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hi Claus", "Hi Willem"});
        try {
            this.template.sendBody("direct:start", (Object)"Claus@James@Willem");
            TryCatchWithSplitNotHandledIssueTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            TryCatchWithSplitNotHandledIssueTest.assertEquals((String)"This is a dummy error James!", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("error", (Object)new GenerateError());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").split((Expression)this.body().tokenize("@")).doTry().to("bean:error")).to("mock:result")).doCatch(Exception.class).handled(false).to("mock:error")).end();
            }
        };
    }

    public static class GenerateError {
        public String dummyException(String payload) throws Exception {
            if (payload.equals("James")) {
                throw new Exception("This is a dummy error James!");
            }
            return "Hi " + payload;
        }
    }
}

