/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.language.tokenizer.TokenizeLanguage;

public class TokenizerTest
extends ExchangeTestSupport {
    @Override
    protected void populateExchange(Exchange exchange) {
        super.populateExchange(exchange);
        exchange.getIn().setHeader("names", (Object)"Claus,James,Willem");
    }

    public void testTokenizeHeader() throws Exception {
        Expression exp = TokenizeLanguage.tokenize((String)"names", (String)",");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)3, (int)names.size());
        TokenizerTest.assertEquals((Object)"Claus", names.get(0));
        TokenizerTest.assertEquals((Object)"James", names.get(1));
        TokenizerTest.assertEquals((Object)"Willem", names.get(2));
    }

    public void testTokenizeBody() throws Exception {
        Expression exp = TokenizeLanguage.tokenize((String)",");
        this.exchange.getIn().setBody((Object)"Hadrian,Charles");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)2, (int)names.size());
        TokenizerTest.assertEquals((Object)"Hadrian", names.get(0));
        TokenizerTest.assertEquals((Object)"Charles", names.get(1));
    }

    public void testTokenizeBodyRegEx() throws Exception {
        Expression exp = TokenizeLanguage.tokenize((String)"(\\W+)\\s*", (boolean)true);
        this.exchange.getIn().setBody((Object)"The little fox");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)3, (int)names.size());
        TokenizerTest.assertEquals((Object)"The", names.get(0));
        TokenizerTest.assertEquals((Object)"little", names.get(1));
        TokenizerTest.assertEquals((Object)"fox", names.get(2));
    }

    public void testTokenizeHeaderRegEx() throws Exception {
        Expression exp = TokenizeLanguage.tokenize((String)"quote", (String)"(\\W+)\\s*", (boolean)true);
        this.exchange.getIn().setHeader("quote", (Object)"Camel rocks");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)2, (int)names.size());
        TokenizerTest.assertEquals((Object)"Camel", names.get(0));
        TokenizerTest.assertEquals((Object)"rocks", names.get(1));
    }

    public void testTokenizeManualConfiguration() throws Exception {
        TokenizeLanguage lan = new TokenizeLanguage();
        lan.setHeaderName("names");
        lan.setRegex(false);
        lan.setToken(",");
        Expression exp = lan.createExpression();
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)3, (int)names.size());
        TokenizerTest.assertEquals((Object)"Claus", names.get(0));
        TokenizerTest.assertEquals((Object)"James", names.get(1));
        TokenizerTest.assertEquals((Object)"Willem", names.get(2));
        TokenizerTest.assertEquals((String)"names", (String)lan.getHeaderName());
        TokenizerTest.assertEquals((String)",", (String)lan.getToken());
        TokenizerTest.assertEquals((boolean)false, (boolean)lan.isRegex());
        TokenizerTest.assertEquals((boolean)false, (boolean)lan.isSingleton());
    }

    public void testTokenizePairSpecial() throws Exception {
        Expression exp = TokenizeLanguage.tokenizePair((String)"!", (String)"@", (boolean)false);
        this.exchange.getIn().setBody((Object)"2011-11-11\n!James@!Claus@\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)2, (int)names.size());
        TokenizerTest.assertEquals((Object)"James", names.get(0));
        TokenizerTest.assertEquals((Object)"Claus", names.get(1));
    }

    public void testTokenizePair() throws Exception {
        Expression exp = TokenizeLanguage.tokenizePair((String)"[START]", (String)"[END]", (boolean)false);
        this.exchange.getIn().setBody((Object)"2011-11-11\n[START]James[END]\n[START]Claus[END]\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)2, (int)names.size());
        TokenizerTest.assertEquals((Object)"James", names.get(0));
        TokenizerTest.assertEquals((Object)"Claus", names.get(1));
    }

    public void testTokenizePairIncludeTokens() throws Exception {
        Expression exp = TokenizeLanguage.tokenizePair((String)"[START]", (String)"[END]", (boolean)true);
        this.exchange.getIn().setBody((Object)"2011-11-11\n[START]James[END]\n[START]Claus[END]\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)2, (int)names.size());
        TokenizerTest.assertEquals((Object)"[START]James[END]", names.get(0));
        TokenizerTest.assertEquals((Object)"[START]Claus[END]", names.get(1));
    }

    public void testTokenizeXMLPair() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<persons><person>James</person><person>Claus</person><person>Jonathan</person><person>Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person>James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person>Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairNoXMLTag() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"person", null);
        this.exchange.getIn().setBody((Object)"<persons><person>James</person><person>Claus</person><person>Jonathan</person><person>Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person>James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person>Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithNoise() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><!-- bla bla --><persons>\n<person>James</person>\n<person>Claus</person>\n<!-- more bla bla --><person>Jonathan</person>\n<person>Hadrian</person>\n</persons>   ");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person>James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person>Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairEmpty() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><!-- bla bla --><persons></persons>   ");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)0, (int)names.size());
    }

    public void testTokenizeXMLPairNoData() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)0, (int)names.size());
    }

    public void testTokenizeXMLPairNullData() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody(null);
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertNull((Object)names);
    }

    public void testTokenizeXMLPairWithSimilarChildNames() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"Trip", (String)"Trips");
        this.exchange.getIn().setBody((Object)"<?xml version='1.0' encoding='UTF-8'?>\n<Trips>\n<Trip>\n<TripType>\n</TripType>\n</Trip>\n</Trips>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)1, (int)names.size());
    }

    public void testTokenizeXMLPairWithDefaultNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", (String)"<persons>");
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person>James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person>Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithDefaultNamespaceNotInherit() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person>James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person>Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person>James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person>Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithDefaultAndFooNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", (String)"<persons>");
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">\n<person>James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person>Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithLocalNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons>\n<person xmlns=\"http:acme.com/persons\">James</person>\n<person xmlns=\"http:acme.com/persons\">Claus</person>\n<person xmlns=\"http:acme.com/persons\">Jonathan</person>\n<person xmlns=\"http:acme.com/persons\">Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithLocalAndInheritedNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", (String)"<persons>");
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person xmlns:foo=\"http:foo.com\">James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person xmlns:bar=\"http:bar.com\">Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person xmlns:foo=\"http:foo.com\" xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person xmlns:bar=\"http:bar.com\" xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithLocalAndNotInheritedNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person xmlns:foo=\"http:foo.com\">James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person xmlns:bar=\"http:bar.com\">Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person xmlns:foo=\"http:foo.com\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person>Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person xmlns:bar=\"http:bar.com\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithAttributes() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", null);
        this.exchange.getIn().setBody((Object)"<persons><person id=\"1\">James</person><person id=\"2\">Claus</person><person id=\"3\">Jonathan</person><person id=\"4\">Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person id=\"1\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person id=\"2\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person id=\"3\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person id=\"4\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithAttributesInheritNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", (String)"<persons>");
        this.exchange.getIn().setBody((Object)"<persons xmlns=\"http:acme.com/persons\"><person id=\"1\">James</person><person id=\"2\">Claus</person><person id=\"3\">Jonathan</person><person id=\"4\">Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person id=\"1\" xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person id=\"2\" xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person id=\"3\" xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person id=\"4\" xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    public void testTokenizeXMLPairWithAttributes2InheritNamespace() throws Exception {
        Expression exp = TokenizeLanguage.tokenizeXML((String)"<person>", (String)"<persons>");
        this.exchange.getIn().setBody((Object)"<persons riders=\"true\" xmlns=\"http:acme.com/persons\"><person id=\"1\">James</person><person id=\"2\">Claus</person><person id=\"3\">Jonathan</person><person id=\"4\">Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        TokenizerTest.assertEquals((int)4, (int)names.size());
        TokenizerTest.assertEquals((Object)"<person id=\"1\" xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        TokenizerTest.assertEquals((Object)"<person id=\"2\" xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        TokenizerTest.assertEquals((Object)"<person id=\"3\" xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        TokenizerTest.assertEquals((Object)"<person id=\"4\" xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }
}

