/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.camel.management.DefaultManagementAgent;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultManagementAgentMockTest {
    @Test
    public void testObjectNameModification() throws JMException {
        MBeanServer mbeanServer = (MBeanServer)EasyMock.createStrictMock(MBeanServer.class);
        ObjectInstance instance = (ObjectInstance)EasyMock.createStrictMock(ObjectInstance.class);
        DefaultManagementAgent agent = new DefaultManagementAgent();
        agent.setMBeanServer(mbeanServer);
        String object = "object";
        ObjectName sourceObjectName = new ObjectName("domain", "key", "value");
        ObjectName registeredObjectName = new ObjectName("domain", "key", "otherValue");
        EasyMock.expect((Object)mbeanServer.isRegistered(sourceObjectName)).andReturn((Object)false);
        EasyMock.expect((Object)mbeanServer.registerMBean(object, sourceObjectName)).andReturn((Object)instance);
        EasyMock.expect((Object)instance.getObjectName()).andReturn((Object)registeredObjectName);
        EasyMock.expect((Object)mbeanServer.isRegistered(registeredObjectName)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{mbeanServer, instance});
        agent.register((Object)object, sourceObjectName);
        Assert.assertTrue((boolean)agent.isRegistered(sourceObjectName));
        EasyMock.verify((Object[])new Object[]{mbeanServer, instance});
        EasyMock.reset((Object[])new Object[]{mbeanServer, instance});
        EasyMock.expect((Object)mbeanServer.isRegistered(registeredObjectName)).andReturn((Object)true);
        mbeanServer.unregisterMBean(registeredObjectName);
        EasyMock.expect((Object)mbeanServer.isRegistered(sourceObjectName)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{mbeanServer});
        agent.unregister(sourceObjectName);
        Assert.assertFalse((boolean)agent.isRegistered(sourceObjectName));
        EasyMock.verify((Object[])new Object[]{mbeanServer});
    }
}

