/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class EventNotifierExchangeCompletedTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return event instanceof ExchangeCompletedEvent;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testExchangeCompleted() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierExchangeCompletedTest.assertEquals((int)1, (int)events.size());
        ExchangeCompletedEvent event = (ExchangeCompletedEvent)events.get(0);
        EventNotifierExchangeCompletedTest.assertNotNull((Object)event.getExchange());
        EventNotifierExchangeCompletedTest.assertNotNull((Object)event.getExchange().getFromEndpoint());
        EventNotifierExchangeCompletedTest.assertEquals((String)"direct://start", (String)event.getExchange().getFromEndpoint().getEndpointUri());
        Date created = (Date)event.getExchange().getProperty("CamelCreatedTimestamp", Date.class);
        EventNotifierExchangeCompletedTest.assertNotNull((Object)created);
        Date now = new Date();
        long elapsed = now.getTime() - created.getTime();
        EventNotifierExchangeCompletedTest.assertTrue((String)("Should be > 400, was: " + elapsed), (elapsed > 400L ? 1 : 0) != 0);
        this.log.info("Elapsed time in millis: " + elapsed);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(500L).to("mock:bar");
            }
        };
    }
}

