/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Service;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStartingEvent;
import org.apache.camel.management.event.CamelContextStoppedEvent;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.management.event.ServiceStopFailureEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;

public class EventNotifierServiceStoppingFailedEventTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();
    private static String stopOrder;

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addService((Object)new MyService("A", false));
        context.addService((Object)new MyService("B", true));
        context.addService((Object)new MyService("C", false));
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testStopWithFailure() throws Exception {
        stopOrder = "";
        this.context.stop();
        EventNotifierServiceStoppingFailedEventTest.assertEquals((String)"CBA", (String)stopOrder);
        EventNotifierServiceStoppingFailedEventTest.assertEquals((int)5, (int)events.size());
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(1));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStoppingEvent.class, events.get(2));
        ServiceStopFailureEvent event = EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(ServiceStopFailureEvent.class, events.get(3));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStoppedEvent.class, events.get(4));
        EventNotifierServiceStoppingFailedEventTest.assertEquals((String)"Fail B", (String)event.getCause().getMessage());
        EventNotifierServiceStoppingFailedEventTest.assertEquals((String)"Failure to stop service: B due to Fail B", (String)event.toString());
    }

    private static final class MyService
    implements Service {
        private String name;
        private boolean fail;

        private MyService(String name, boolean fail) {
            this.name = name;
            this.fail = fail;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
            stopOrder = stopOrder + this.name;
            if (this.fail) {
                throw new IllegalArgumentException("Fail " + this.name);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

