/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class JmxInstrumentationUsingDefaultsTest
extends ContextTestSupport {
    protected String domainName = "org.apache.camel";
    protected MBeanServerConnection mbsc;
    protected long sleepForConnection;

    @Override
    protected boolean useJmx() {
        return true;
    }

    protected void assertDefaultDomain() throws IOException {
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null && !Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer")) {
            JmxInstrumentationUsingDefaultsTest.assertEquals((String)this.domainName, (String)this.mbsc.getDefaultDomain());
        }
    }

    public void testMBeansRegistered() throws Exception {
        if (JmxInstrumentationUsingDefaultsTest.isPlatform("aix")) {
            return;
        }
        this.assertDefaultDomain();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 2 endpoints: " + s), (int)2, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 1 context: " + s), (int)1, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 1 processors: " + s), (int)2, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=consumers,*"), null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 1 consumers: " + s), (int)1, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=producers,*"), null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 2 producers: " + s), (int)0, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 1 route: " + s), (int)1, (int)s.size());
    }

    public void testCounters() throws Exception {
        if (JmxInstrumentationUsingDefaultsTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        this.verifyCounter(this.mbsc, new ObjectName(this.domainName + ":type=routes,*"));
    }

    protected void verifyCounter(MBeanServerConnection beanServer, ObjectName name) throws Exception {
        Set<ObjectName> s = beanServer.queryNames(name, null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Found mbeans: " + s), (int)1, (int)s.size());
        Iterator<ObjectName> iter = s.iterator();
        ObjectName pcob = iter.next();
        Long valueofNumExchanges = (Long)beanServer.getAttribute(pcob, "ExchangesTotal");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofNumExchanges);
        JmxInstrumentationUsingDefaultsTest.assertEquals((Object)1L, (Object)valueofNumExchanges);
        Long valueofNumCompleted = (Long)beanServer.getAttribute(pcob, "ExchangesCompleted");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofNumCompleted);
        JmxInstrumentationUsingDefaultsTest.assertEquals((Object)1L, (Object)valueofNumCompleted);
        Long valueofNumFailed = (Long)beanServer.getAttribute(pcob, "ExchangesFailed");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofNumFailed);
        JmxInstrumentationUsingDefaultsTest.assertEquals((Object)0L, (Object)valueofNumFailed);
        Long valueofMinProcessingTime = (Long)beanServer.getAttribute(pcob, "MinProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofMinProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofMinProcessingTime >= 0L ? 1 : 0) != 0);
        Long valueofMaxProcessingTime = (Long)beanServer.getAttribute(pcob, "MaxProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofMaxProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofMaxProcessingTime >= 0L ? 1 : 0) != 0);
        Long valueofMeanProcessingTime = (Long)beanServer.getAttribute(pcob, "MeanProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofMeanProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofMeanProcessingTime >= valueofMinProcessingTime && valueofMeanProcessingTime <= valueofMaxProcessingTime ? 1 : 0) != 0);
        Long totalProcessingTime = (Long)beanServer.getAttribute(pcob, "TotalProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)totalProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((totalProcessingTime >= 0L ? 1 : 0) != 0);
        Long lastProcessingTime = (Long)beanServer.getAttribute(pcob, "LastProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)lastProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((lastProcessingTime >= 0L ? 1 : 0) != 0);
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected first completion time to be available", (Object)beanServer.getAttribute(pcob, "FirstExchangeCompletedTimestamp"));
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected last completion time to be available", (Object)beanServer.getAttribute(pcob, "LastExchangeCompletedTimestamp"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").delay(10L).to("mock:end");
            }
        };
    }

    @Override
    protected void setUp() throws Exception {
        this.releaseMBeanServers();
        super.setUp();
        Thread.sleep(this.sleepForConnection);
        this.mbsc = this.getMBeanConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
            this.releaseMBeanServers();
            this.mbsc = null;
        }
        finally {
            System.clearProperty("org.apache.camel.jmx.usePlatformMBeanServer");
            System.clearProperty("org.apache.camel.jmx.mbeanServerDefaultDomain");
            System.clearProperty("org.apache.camel.jmx.mbeanObjectDomainName");
            System.clearProperty("org.apache.camel.jmx.createRmiConnector");
            System.clearProperty("org.apache.camel.jmx.rmiConnector.registryPort");
        }
    }

    protected void releaseMBeanServers() {
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    protected MBeanServerConnection getMBeanConnection() throws Exception {
        if (this.mbsc == null) {
            this.mbsc = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbsc;
    }
}

