/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;

public class ManagedCamelContextDumpStatsAsXmlTest
extends ManagementTestSupport {
    public void testPerformanceCounterStats() throws Exception {
        if (ManagedCamelContextDumpStatsAsXmlTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.template.asyncSendBody("direct:bar", (Object)"Hi World");
        this.template.asyncSendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesStatsAsXml", new Object[]{false, true}, new String[]{"boolean", "boolean"});
        this.log.info(xml);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        ManagedCamelContextDumpStatsAsXmlTest.assertNotNull((Object)doc);
        int processors = doc.getDocumentElement().getElementsByTagName("processorStat").getLength();
        ManagedCamelContextDumpStatsAsXmlTest.assertEquals((int)5, (int)processors);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).id("a")).delay(100L).id("b")).to("mock:foo")).id("c");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).id("d")).to("mock:bar")).id("e");
            }
        };
    }
}

