/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRouteDumpRouteAsXmlTest
extends ManagementTestSupport {
    public void testDumpAsXml() throws Exception {
        if (ManagedRouteDumpRouteAsXmlTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteDumpRouteAsXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteDumpRouteAsXmlTest.assertEquals((String)"myRoute", (String)routeId);
        String xml = (String)mbeanServer.invoke(on, "dumpRouteAsXml", null, null);
        ManagedRouteDumpRouteAsXmlTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedRouteDumpRouteAsXmlTest.assertTrue((boolean)xml.contains("route"));
        ManagedRouteDumpRouteAsXmlTest.assertTrue((boolean)xml.contains("myRoute"));
        ManagedRouteDumpRouteAsXmlTest.assertTrue((boolean)xml.contains("mock:result"));
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteDumpRouteAsXmlTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("mock:result");
            }
        };
    }
}

