/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;

public class ManagedRoutePolicyTest
extends ManagementTestSupport {
    public void testRoutes() throws Exception {
        if (ManagedRoutePolicyTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRoutePolicyTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRoutePolicyTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedRoutePolicyTest.assertEquals((String)"direct://start", (String)uri);
        Integer val = (Integer)mbeanServer.getAttribute(on, "InflightExchanges");
        ManagedRoutePolicyTest.assertEquals((int)0, (int)val);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRoutePolicyTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        String policy = (String)mbeanServer.getAttribute(on, "RoutePolicyList");
        ManagedRoutePolicyTest.assertNotNull((Object)policy);
        ManagedRoutePolicyTest.assertTrue((String)("Should be a throttling, was: " + policy), (boolean)policy.startsWith("ThrottlingInflightRoutePolicy"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routePolicy(new RoutePolicy[]{new ThrottlingInflightRoutePolicy()}).to("log:foo")).to("mock:result");
            }
        };
    }
}

