/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRouteStopAndStartTest
extends ManagementTestSupport {
    @Override
    protected void setUp() throws Exception {
        ManagedRouteStopAndStartTest.deleteDirectory("target/managed");
        super.setUp();
    }

    public void testStopAndStartRoute() throws Exception {
        if (ManagedRouteStopAndStartTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopAndStartTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(3000L);
        this.template.sendBodyAndHeader("file://target/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mbeanServer.invoke(on, "start", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        mock.assertIsSatisfied();
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopAndStartTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/managed").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

