/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRouteStopUsingMBeanAPITest
extends ManagementTestSupport {
    public void testStopRoute() throws Exception {
        if (ManagedRouteStopUsingMBeanAPITest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopUsingMBeanAPITest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        ManagedRouteMBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, on, ManagedRouteMBean.class, false);
        ManagedRouteStopUsingMBeanAPITest.assertEquals((String)"direct://start", (String)mbean.getEndpointUri());
        ManagedRouteStopUsingMBeanAPITest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)mbean.getState());
        mbean.stop();
        ManagedRouteStopUsingMBeanAPITest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)mbean.getState());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

