/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedThreadPoolTest
extends ManagementTestSupport {
    public void testManagedThreadPool() throws Exception {
        if (ManagedThreadPoolTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads1(threads)\"");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        ManagedThreadPoolTest.assertEquals((boolean)false, (boolean)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        ManagedThreadPoolTest.assertEquals((int)15, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        ManagedThreadPoolTest.assertEquals((int)30, (int)maxPoolSize);
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolTest.assertEquals((int)0, (int)poolSize);
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        ManagedThreadPoolTest.assertEquals((int)60, (int)keepAlive.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(2000L);
        poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolTest.assertEquals((int)1, (int)poolSize);
        Integer largest = (Integer)mbeanServer.getAttribute(on, "LargestPoolSize");
        ManagedThreadPoolTest.assertEquals((int)1, (int)largest);
        Long completed = (Long)mbeanServer.getAttribute(on, "CompletedTaskCount");
        ManagedThreadPoolTest.assertEquals((int)1, (int)completed.intValue());
        Long size = (Long)mbeanServer.getAttribute(on, "TaskQueueSize");
        ManagedThreadPoolTest.assertEquals((int)0, (int)size.intValue());
        Boolean empty = (Boolean)mbeanServer.getAttribute(on, "TaskQueueEmpty");
        ManagedThreadPoolTest.assertEquals((boolean)true, (boolean)empty);
        int remainingCapacity = (Integer)mbeanServer.invoke(on, "getTaskQueueRemainingCapacity", null, null);
        ManagedThreadPoolTest.assertEquals((String)"remainingCapacity", (int)200, (int)remainingCapacity);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").threads(15, 30).maxQueueSize(200).to("mock:result");
            }
        };
    }
}

