/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class ManagedThrottlerTest
extends ManagementTestSupport {
    public void testManageThrottler() throws Exception {
        if (ManagedThrottlerTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mythrottler\"");
        ObjectName routeName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        mbeanServer.invoke(routeName, "reset", null, null);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        ManagedThrottlerTest.assertEquals((long)10L, (long)completed);
        Long timePeriod = (Long)mbeanServer.getAttribute(throttlerName, "TimePeriodMillis");
        ManagedThrottlerTest.assertEquals((long)1000L, (long)timePeriod);
        Long total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        ManagedThrottlerTest.assertTrue((String)("Should take at most 2.0 sec: was " + total), (total < 2000L ? 1 : 0) != 0);
        mbeanServer.setAttribute(throttlerName, new Attribute("MaximumRequestsPerPeriod", 2L));
        mbeanServer.invoke(routeName, "reset", null, null);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        Long period = (Long)mbeanServer.getAttribute(throttlerName, "MaximumRequestsPerPeriod");
        ManagedThrottlerTest.assertNotNull((Object)period);
        ManagedThrottlerTest.assertEquals((long)2L, (long)period);
        completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        ManagedThrottlerTest.assertEquals((long)10L, (long)completed);
        total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        ManagedThrottlerTest.assertTrue((String)("Should be around 5 sec now: was " + total), (total > 3500L ? 1 : 0) != 0);
    }

    public void testThrottleVisableViaJmx() throws Exception {
        if (ManagedThrottlerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mythrottler2\"");
        ObjectName routeName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route2\"");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:end").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCount").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCount", (Object)("Message " + i));
        }
        ManagedThrottlerTest.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        Integer throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertTrue((throttledMessages > 0 ? 1 : 0) != 0);
        this.assertMockEndpointsSatisfied();
        throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertEquals((String)("Should not be any throttled messages left, found: " + throttledMessages), (Object)0, (Object)throttledMessages);
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        ManagedThrottlerTest.assertEquals((long)10L, (long)completed);
    }

    public void testThrottleAsyncVisableViaJmx() throws Exception {
        if (ManagedThrottlerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mythrottler3\"");
        ObjectName routeName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route3\"");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:endAsync").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCountAsync").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountAsync", (Object)("Message " + i));
        }
        ManagedThrottlerTest.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        Integer throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertTrue((throttledMessages > 0 ? 1 : 0) != 0);
        this.assertMockEndpointsSatisfied();
        throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertEquals((String)("Should not be any throttled messages left, found: " + throttledMessages), (Object)0, (Object)throttledMessages);
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        ManagedThrottlerTest.assertEquals((long)10L, (long)completed);
    }

    public void testThrottleAsyncExceptionVisableViaJmx() throws Exception {
        if (ManagedThrottlerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mythrottler4\"");
        ObjectName routeName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route4\"");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:endAsyncException").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCountAsyncException").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountAsyncException", (Object)("Message " + i));
        }
        ManagedThrottlerTest.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        Integer throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertTrue((throttledMessages > 0 ? 1 : 0) != 0);
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertEquals((String)("Should not be any throttled messages left, found: " + throttledMessages), (Object)0, (Object)throttledMessages);
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        ManagedThrottlerTest.assertEquals((long)0L, (long)completed);
    }

    public void testRejectedExecution() throws Exception {
        if (ManagedThrottlerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mythrottler2\"");
        ObjectName routeName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route2\"");
        mbeanServer.invoke(routeName, "reset", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:endAsyncReject");
        mock.expectedMessageCount(1);
        MockEndpoint exceptionMock = this.getMockEndpoint("mock:rejectedExceptionEndpoint1");
        exceptionMock.expectedMessageCount(9);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountRejectExecution", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        Integer throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertEquals((String)("Should not be any throttled messages left, found: " + throttledMessages), (Object)0, (Object)throttledMessages);
    }

    public void testRejectedExecutionCallerRuns() throws Exception {
        if (ManagedThrottlerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mythrottler2\"");
        ObjectName routeName = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route2\"");
        mbeanServer.invoke(routeName, "reset", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:endAsyncRejectCallerRuns");
        mock.expectedMessageCount(10);
        MockEndpoint exceptionMock = this.getMockEndpoint("mock:rejectedExceptionEndpoint");
        exceptionMock.expectedMessageCount(0);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountRejectExecutionCallerRuns", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        Integer throttledMessages = (Integer)mbeanServer.getAttribute(throttlerName, "ThrottledCount");
        ManagedThrottlerTest.assertEquals((String)("Should not be any throttled messages left, found: " + throttledMessages), (Object)0, (Object)throttledMessages);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        final ScheduledThreadPoolExecutor badService = new ScheduledThreadPoolExecutor(1){

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                throw new RejectedExecutionException();
            }
        };
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("direct:start").to("log:foo")).throttle(10L).id("mythrottler")).to("mock:result");
                ((ExpressionNode)this.from("seda:throttleCount").throttle(1L).timePeriodMillis(250L).id("mythrottler2")).to("mock:end");
                ((ExpressionNode)this.from("seda:throttleCountAsync").throttle(1L).asyncDelayed().timePeriodMillis(250L).id("mythrottler3")).to("mock:endAsync");
                ((ExpressionNode)((ExpressionNode)this.from("seda:throttleCountAsyncException").throttle(1L).asyncDelayed().timePeriodMillis(250L).id("mythrottler4")).to("mock:endAsyncException")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new RuntimeException("Fail me");
                    }
                });
                ((ExpressionNode)((OnExceptionDefinition)this.from("seda:throttleCountRejectExecutionCallerRuns").onException(RejectedExecutionException.class).to("mock:rejectedExceptionEndpoint1")).end().throttle(1L).timePeriodMillis(250L).asyncDelayed().executorService((ExecutorService)badService).callerRunsWhenRejected(true).id("mythrottler5")).to("mock:endAsyncRejectCallerRuns");
                ((ExpressionNode)((OnExceptionDefinition)this.from("seda:throttleCountRejectExecution").onException(RejectedExecutionException.class).to("mock:rejectedExceptionEndpoint1")).end().throttle(1L).timePeriodMillis(250L).asyncDelayed().executorService((ExecutorService)badService).callerRunsWhenRejected(false).id("mythrottler6")).to("mock:endAsyncReject");
            }
        };
    }
}

