/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedTracerOptionsTest
extends ManagementTestSupport {
    public void testManagedTracerOptions() throws Exception {
        if (ManagedTracerOptionsTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=Tracer");
        mbeanServer.isRegistered(on);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)enabled);
        mbeanServer.setAttribute(on, new Attribute("DestinationUri", null));
        String duri = (String)mbeanServer.getAttribute(on, "DestinationUri");
        ManagedTracerOptionsTest.assertEquals(null, (String)duri);
        mbeanServer.setAttribute(on, new Attribute("DestinationUri", "mock://traced"));
        duri = (String)mbeanServer.getAttribute(on, "DestinationUri");
        ManagedTracerOptionsTest.assertEquals((String)"mock://traced", (String)duri);
        Boolean useJpa = (Boolean)mbeanServer.getAttribute(on, "UseJpa");
        ManagedTracerOptionsTest.assertEquals((boolean)false, (boolean)useJpa);
        mbeanServer.setAttribute(on, new Attribute("LogName", "foo"));
        String ln = (String)mbeanServer.getAttribute(on, "LogName");
        ManagedTracerOptionsTest.assertEquals((String)"foo", (String)ln);
        mbeanServer.setAttribute(on, new Attribute("LogLevel", "WARN"));
        String ll = (String)mbeanServer.getAttribute(on, "LogLevel");
        ManagedTracerOptionsTest.assertEquals((String)LoggingLevel.WARN.name(), (String)ll);
        mbeanServer.setAttribute(on, new Attribute("LogStackTrace", Boolean.TRUE));
        Boolean lst = (Boolean)mbeanServer.getAttribute(on, "LogStackTrace");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)lst);
        mbeanServer.setAttribute(on, new Attribute("TraceInterceptors", Boolean.TRUE));
        Boolean ti = (Boolean)mbeanServer.getAttribute(on, "TraceInterceptors");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)ti);
        mbeanServer.setAttribute(on, new Attribute("TraceExceptions", Boolean.TRUE));
        Boolean te = (Boolean)mbeanServer.getAttribute(on, "TraceExceptions");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)te);
        mbeanServer.setAttribute(on, new Attribute("TraceOutExchanges", Boolean.TRUE));
        Boolean toe = (Boolean)mbeanServer.getAttribute(on, "TraceOutExchanges");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)toe);
        this.doAssertFormatter(mbeanServer, on);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    private void doAssertFormatter(MBeanServer mbeanServer, ObjectName on) throws Exception {
        if (ManagedTracerOptionsTest.isPlatform("aix")) {
            return;
        }
        mbeanServer.setAttribute(on, new Attribute("FormatterShowBody", Boolean.TRUE));
        Boolean fsb = (Boolean)mbeanServer.getAttribute(on, "FormatterShowBody");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsb);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowBodyType", Boolean.TRUE));
        Boolean fsbt = (Boolean)mbeanServer.getAttribute(on, "FormatterShowBodyType");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsbt);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowOutBody", Boolean.TRUE));
        Boolean fsob = (Boolean)mbeanServer.getAttribute(on, "FormatterShowOutBody");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsob);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowOutBodyType", Boolean.TRUE));
        Boolean fsobt = (Boolean)mbeanServer.getAttribute(on, "FormatterShowOutBodyType");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsobt);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowBreadCrumb", Boolean.TRUE));
        Boolean fsbc = (Boolean)mbeanServer.getAttribute(on, "FormatterShowBreadCrumb");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsbc);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowExchangeId", Boolean.TRUE));
        Boolean fsei = (Boolean)mbeanServer.getAttribute(on, "FormatterShowExchangeId");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsei);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowShortExchangeId", Boolean.TRUE));
        Boolean fssei = (Boolean)mbeanServer.getAttribute(on, "FormatterShowShortExchangeId");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fssei);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowHeaders", Boolean.TRUE));
        Boolean fsh = (Boolean)mbeanServer.getAttribute(on, "FormatterShowHeaders");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsh);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowOutHeaders", Boolean.TRUE));
        Boolean fsoh = (Boolean)mbeanServer.getAttribute(on, "FormatterShowOutHeaders");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsoh);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowProperties", Boolean.TRUE));
        Boolean fsp = (Boolean)mbeanServer.getAttribute(on, "FormatterShowProperties");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsp);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowNode", Boolean.TRUE));
        Boolean fsn = (Boolean)mbeanServer.getAttribute(on, "FormatterShowNode");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsn);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowRouteId", Boolean.FALSE));
        Boolean fsr = (Boolean)mbeanServer.getAttribute(on, "FormatterShowRouteId");
        ManagedTracerOptionsTest.assertEquals((boolean)false, (boolean)fsr);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowExchangePattern", Boolean.TRUE));
        Boolean fsep = (Boolean)mbeanServer.getAttribute(on, "FormatterShowExchangePattern");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsep);
        mbeanServer.setAttribute(on, new Attribute("FormatterShowException", Boolean.TRUE));
        Boolean fsex = (Boolean)mbeanServer.getAttribute(on, "FormatterShowException");
        ManagedTracerOptionsTest.assertEquals((boolean)true, (boolean)fsex);
        mbeanServer.setAttribute(on, new Attribute("FormatterBreadCrumbLength", 100));
        Integer fbcl = (Integer)mbeanServer.getAttribute(on, "FormatterBreadCrumbLength");
        ManagedTracerOptionsTest.assertEquals((int)100, (int)fbcl);
        mbeanServer.setAttribute(on, new Attribute("FormatterNodeLength", 50));
        Integer fnl = (Integer)mbeanServer.getAttribute(on, "FormatterNodeLength");
        ManagedTracerOptionsTest.assertEquals((int)50, (int)fnl);
        mbeanServer.setAttribute(on, new Attribute("FormatterMaxChars", 250));
        Integer fmc = (Integer)mbeanServer.getAttribute(on, "FormatterMaxChars");
        ManagedTracerOptionsTest.assertEquals((int)250, (int)fmc);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedTracerOptionsTest.this.context.setTracing(Boolean.valueOf(true));
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

