/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetOutHeaderDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.XmlTestSupport;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;

public class XmlParseTest
extends XmlTestSupport {
    public void testParseSimpleRouteXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("simpleRoute.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo("to", (ProcessorDefinition<?>)route, "seda:b");
    }

    public void testParseProcessorXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processor.xml");
        this.assertFrom(route, "seda:a");
        ProcessDefinition to = this.assertOneProcessorInstanceOf((Class)ProcessDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"Processor ref", (String)"myProcessor", (String)to.getRef());
    }

    public void testParseProcessorWithFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf((Class)FilterDefinition.class, (ProcessorDefinition<?>)route);
        this.assertExpression(filter.getExpression(), "juel", "in.header.foo == 'bar'");
    }

    public void testParseProcessorWithHeaderFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithHeaderFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf((Class)FilterDefinition.class, (ProcessorDefinition<?>)route);
        this.assertExpression(filter.getExpression(), "header", "foo");
    }

    public void testParseProcessorWithElFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithElFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf((Class)FilterDefinition.class, (ProcessorDefinition<?>)route);
        this.assertExpression(filter.getExpression(), "el", "$in.header.foo == 'bar'");
    }

    public void testParseProcessorWithGroovyFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithGroovyFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf((Class)FilterDefinition.class, (ProcessorDefinition<?>)route);
        this.assertExpression(filter.getExpression(), "groovy", "in.headers.any { h -> h.startsWith('foo')}");
    }

    public void testParseRecipientListXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("dynamicRecipientList.xml");
        this.assertFrom(route, "seda:a");
        RecipientListDefinition node = this.assertOneProcessorInstanceOf((Class)RecipientListDefinition.class, (ProcessorDefinition<?>)route);
        this.assertExpression(node.getExpression(), "header", "foo");
    }

    public void testParseStaticRecipientListXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("staticRecipientList.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo((ProcessorDefinition<?>)route, "seda:b", "seda:c", "seda:d");
    }

    public void testParseTransformXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("transform.xml");
        this.assertFrom(route, "direct:start");
        TransformDefinition node = this.assertNthProcessorInstanceOf((Class)TransformDefinition.class, (ProcessorDefinition<?>)route, 0);
        this.assertExpression(node.getExpression(), "simple", "${in.body} extra data!");
        this.assertChildTo((ProcessorDefinition<?>)route, "mock:end", 1);
    }

    public void testParseSetBodyXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setBody.xml");
        this.assertFrom(route, "direct:start");
        SetBodyDefinition node = this.assertNthProcessorInstanceOf((Class)SetBodyDefinition.class, (ProcessorDefinition<?>)route, 0);
        this.assertExpression(node.getExpression(), "simple", "${in.body} extra data!");
        this.assertChildTo((ProcessorDefinition<?>)route, "mock:end", 1);
    }

    public void testParseSetHeaderXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setHeader.xml");
        this.assertFrom(route, "seda:a");
        SetHeaderDefinition node = this.assertNthProcessorInstanceOf((Class)SetHeaderDefinition.class, (ProcessorDefinition<?>)route, 0);
        XmlParseTest.assertEquals((String)"oldBodyValue", (String)node.getHeaderName());
        this.assertExpression(node.getExpression(), "simple", "body");
        this.assertChildTo((ProcessorDefinition<?>)route, "mock:b", 1);
    }

    public void testParseSetHeaderToConstantXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setHeaderToConstant.xml");
        this.assertFrom(route, "seda:a");
        SetHeaderDefinition node = this.assertNthProcessorInstanceOf((Class)SetHeaderDefinition.class, (ProcessorDefinition<?>)route, 0);
        XmlParseTest.assertEquals((String)"theHeader", (String)node.getHeaderName());
        this.assertExpression(node.getExpression(), "constant", "a value");
        this.assertChildTo((ProcessorDefinition<?>)route, "mock:b", 1);
    }

    public void testParseSetOutHeaderXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setOutHeader.xml");
        this.assertFrom(route, "seda:a");
        SetOutHeaderDefinition node = this.assertNthProcessorInstanceOf((Class)SetOutHeaderDefinition.class, (ProcessorDefinition<?>)route, 0);
        XmlParseTest.assertEquals((String)"oldBodyValue", (String)node.getHeaderName());
        this.assertExpression(node.getExpression(), "simple", "body");
        this.assertChildTo((ProcessorDefinition<?>)route, "mock:b", 1);
    }

    public void testParseSetOutHeaderToConstantXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setOutHeaderToConstant.xml");
        this.assertFrom(route, "seda:a");
        SetOutHeaderDefinition node = this.assertNthProcessorInstanceOf((Class)SetOutHeaderDefinition.class, (ProcessorDefinition<?>)route, 0);
        XmlParseTest.assertEquals((String)"theHeader", (String)node.getHeaderName());
        this.assertExpression(node.getExpression(), "constant", "a value");
        this.assertChildTo((ProcessorDefinition<?>)route, "mock:b", 1);
    }

    public void testParseConvertBodyXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("convertBody.xml");
        this.assertFrom(route, "seda:a");
        ConvertBodyDefinition node = this.assertOneProcessorInstanceOf((Class)ConvertBodyDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"java.lang.Integer", (String)node.getType());
    }

    public void testParseRoutingSlipXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routingSlip.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipDefinition node = this.assertOneProcessorInstanceOf((Class)RoutingSlipDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"destinations", (String)node.getExpression().getExpression());
        XmlParseTest.assertEquals((String)",", (String)node.getUriDelimiter());
    }

    public void testParseRoutingSlipWithHeaderSetXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routingSlipHeaderSet.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipDefinition node = this.assertOneProcessorInstanceOf((Class)RoutingSlipDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"theRoutingSlipHeader", (String)node.getExpression().getExpression());
        XmlParseTest.assertEquals((String)",", (String)node.getUriDelimiter());
    }

    public void testParseRoutingSlipWithHeaderAndDelimiterSetXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routingSlipHeaderAndDelimiterSet.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipDefinition node = this.assertOneProcessorInstanceOf((Class)RoutingSlipDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"theRoutingSlipHeader", (String)node.getExpression().getExpression());
        XmlParseTest.assertEquals((String)"#", (String)node.getUriDelimiter());
    }

    public void testParseRouteWithChoiceXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithChoice.xml");
        this.assertFrom(route, "seda:a");
        ChoiceDefinition choice = this.assertOneProcessorInstanceOf((Class)ChoiceDefinition.class, (ProcessorDefinition<?>)route);
        List whens = XmlParseTest.assertListSize(choice.getWhenClauses(), 2);
        this.assertChildTo("when(0)", (ProcessorDefinition)whens.get(0), "seda:b");
        this.assertChildTo("when(1)", (ProcessorDefinition)whens.get(1), "seda:c");
        OtherwiseDefinition otherwise = choice.getOtherwise();
        XmlParseTest.assertNotNull((String)"Otherwise is null", (Object)otherwise);
        this.assertChildTo("otherwise", (ProcessorDefinition<?>)otherwise, "seda:d");
    }

    public void testParseSplitterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("splitter.xml");
        this.assertFrom(route, "seda:a");
        SplitDefinition splitter = this.assertOneProcessorInstanceOf((Class)SplitDefinition.class, (ProcessorDefinition<?>)route);
        this.assertExpression(splitter.getExpression(), "xpath", "/foo/bar");
        this.assertChildTo("to", (ProcessorDefinition<?>)splitter, "seda:b");
    }

    public void testParseLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf((Class)LoadBalanceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be RoundRobinLoadBalancerDefinition", (boolean)(loadBalance.getLoadBalancerType() instanceof RoundRobinLoadBalancerDefinition));
    }

    public void testParseStickyLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithStickyLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf((Class)LoadBalanceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be StickyLoadBalancerDefinition", (boolean)(loadBalance.getLoadBalancerType() instanceof StickyLoadBalancerDefinition));
        StickyLoadBalancerDefinition strategy = (StickyLoadBalancerDefinition)loadBalance.getLoadBalancerType();
        XmlParseTest.assertNotNull((String)"the expression should not be null ", (Object)strategy.getCorrelationExpression());
    }

    public void testParseFailoverLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithFailoverLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf((Class)LoadBalanceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be FailoverLoadBalancerDefinition", (boolean)(loadBalance.getLoadBalancerType() instanceof FailoverLoadBalancerDefinition));
        FailoverLoadBalancerDefinition strategy = (FailoverLoadBalancerDefinition)loadBalance.getLoadBalancerType();
        XmlParseTest.assertEquals((String)"there should be 2 exceptions", (int)2, (int)strategy.getExceptions().size());
    }

    public void testParseRandomLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithRandomLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf((Class)LoadBalanceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be RandomLoadBalancerDefinition", (boolean)(loadBalance.getLoadBalancerType() instanceof RandomLoadBalancerDefinition));
    }

    public void testParseTopicLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithTopicLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf((Class)LoadBalanceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be TopicLoadBalancerDefinition", (boolean)(loadBalance.getLoadBalancerType() instanceof TopicLoadBalancerDefinition));
    }

    public void testParseHL7DataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithHL7DataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseXStreamDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithXStreamDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseJibxDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithJibxDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseXMLBeansDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithXMLBeansDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseXMLSecurityDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithXMLSecurityDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseTidyMarkupDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithTidyMarkupDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseRSSDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithRSSDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseJSonDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithJSonDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseJaxbDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithJaxbDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseFlatpackDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithFlatpackDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseCvsDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithCvsDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseZipFileDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithZipFileDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseBindyDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithBindyDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseCastorDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithCastorDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    public void testParseBatchResequencerXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("resequencerBatch.xml");
        ResequenceDefinition resequencer = this.assertOneProcessorInstanceOf((Class)ResequenceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertNull((Object)resequencer.getStreamConfig());
        XmlParseTest.assertNotNull((Object)resequencer.getBatchConfig());
        XmlParseTest.assertEquals((int)500, (int)resequencer.getBatchConfig().getBatchSize());
        XmlParseTest.assertEquals((long)2000L, (long)resequencer.getBatchConfig().getBatchTimeout());
    }

    public void testParseStreamResequencerXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("resequencerStream.xml");
        ResequenceDefinition resequencer = this.assertOneProcessorInstanceOf((Class)ResequenceDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertNotNull((Object)resequencer.getStreamConfig());
        XmlParseTest.assertNull((Object)resequencer.getBatchConfig());
        XmlParseTest.assertEquals((int)1000, (int)resequencer.getStreamConfig().getCapacity());
        XmlParseTest.assertEquals((long)2000L, (long)resequencer.getStreamConfig().getTimeout());
    }

    public void testLoop() throws Exception {
        RouteDefinition route = this.assertOneRoute("loop.xml");
        LoopDefinition loop = this.assertOneProcessorInstanceOf((Class)LoopDefinition.class, (ProcessorDefinition<?>)route);
        XmlParseTest.assertNotNull((Object)loop.getExpression());
        XmlParseTest.assertEquals((String)"constant", (String)loop.getExpression().getLanguage());
    }

    protected RouteDefinition assertOneRoute(String uri) throws JAXBException {
        RouteContainer context = this.assertParseAsJaxb(uri);
        RouteDefinition route = (RouteDefinition)XmlParseTest.assertOneElement(context.getRoutes());
        return route;
    }

    protected void assertFrom(RouteDefinition route, String uri) {
        FromDefinition from = (FromDefinition)XmlParseTest.assertOneElement(route.getInputs());
        XmlParseTest.assertEquals((String)"From URI", (String)uri, (String)from.getUri());
    }

    protected void assertChildTo(String message, ProcessorDefinition<?> route, String uri) {
        ProcessorDefinition processor = (ProcessorDefinition)XmlParseTest.assertOneElement(route.getOutputs());
        ToDefinition value = XmlParseTest.assertIsInstanceOf(ToDefinition.class, processor);
        String text = message + "To URI";
        this.log.info("Testing: " + text + " is equal to: " + uri + " for processor: " + processor);
        XmlParseTest.assertEquals((String)text, (String)uri, (String)value.getUri());
    }

    protected void assertTo(String message, ProcessorDefinition<?> processor, String uri) {
        ToDefinition value = XmlParseTest.assertIsInstanceOf(ToDefinition.class, processor);
        String text = message + "To URI";
        this.log.info("Testing: " + text + " is equal to: " + uri + " for processor: " + processor);
        XmlParseTest.assertEquals((String)text, (String)uri, (String)value.getUri());
    }

    protected void assertChildTo(ProcessorDefinition<?> route, String ... uris) {
        List list = XmlParseTest.assertListSize(route.getOutputs(), uris.length);
        int idx = 0;
        for (String uri : uris) {
            this.assertTo("output[" + idx + "] ", (ProcessorDefinition)list.get(idx++), uri);
        }
    }

    protected void assertChildTo(ProcessorDefinition<?> route, String uri, int toIdx) {
        List list = route.getOutputs();
        this.assertTo("to and idx=" + toIdx, (ProcessorDefinition)list.get(toIdx), uri);
    }

    protected <T> T assertOneProcessorInstanceOf(Class<T> type, ProcessorDefinition<?> route) {
        ProcessorDefinition processor = (ProcessorDefinition)XmlParseTest.assertOneElement(route.getOutputs());
        return XmlParseTest.assertIsInstanceOf(type, processor);
    }

    protected <T> T assertNthProcessorInstanceOf(Class<T> type, ProcessorDefinition<?> route, int index) {
        ProcessorDefinition processor = (ProcessorDefinition)route.getOutputs().get(index);
        return XmlParseTest.assertIsInstanceOf(type, processor);
    }

    protected void assertExpression(ExpressionDefinition expression, String language, String languageExpression) {
        XmlParseTest.assertNotNull((String)"Expression should not be null!", (Object)expression);
        XmlParseTest.assertEquals((String)"Expression language", (String)language, (String)expression.getLanguage());
        XmlParseTest.assertEquals((String)"Expression", (String)languageExpression, (String)expression.getExpression());
    }
}

