/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;

public class BeanValidateTypeTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("cool", (Object)new MyCoolBean());
        return jndi;
    }

    public void testBeanValidateType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").bean((Object)"cool");
            }
        });
        try {
            this.context.start();
            BeanValidateTypeTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            BeanValidateTypeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            BeanValidateTypeTest.assertTrue((boolean)e.getCause().getMessage().startsWith("The bean instance is a java.lang.String type: cool."));
        }
    }

    public static class MyCoolBean {
        public String hello(String s) {
            return "Hello " + s;
        }
    }
}

