/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Processor;
import org.apache.camel.Property;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithExceptionTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"<valid/>");
                exchange.getIn().setHeader("foo", (Object)"bar");
                exchange.setProperty("cheese", (Object)"old");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.invalidEndpoint.expectedMessageCount(1);
        Exchange exchange = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"<invalid/>");
                exchange.getIn().setHeader("foo", (Object)"notMatchedHeaderValue");
                exchange.setProperty("cheese", (Object)"old");
            }
        });
        BeanWithExceptionTest.assertNotNull((Object)exchange.getException());
        ValidationException exception = BeanWithExceptionTest.assertIsInstanceOf(ValidationException.class, exchange.getException());
        BeanWithExceptionTest.assertEquals((String)"Invalid header foo: notMatchedHeaderValue", (String)exception.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new ValidationBean());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(ValidationException.class).to("mock:invalid");
                ((RouteDefinition)this.from("direct:start").beanRef("myBean")).to("mock:valid");
            }
        };
    }

    public static class ValidationBean {
        private static final Logger LOG = LoggerFactory.getLogger(ValidationBean.class);

        public void someMethod(String body, @Header(value="foo") String header, @Property(value="cheese") String cheese) throws ValidationException {
            TestCase.assertEquals((String)"old", (String)cheese);
            if (!"bar".equals(header)) {
                throw new ValidationException(null, "Invalid header foo: " + header);
            }
            LOG.info("someMethod() called with valid header and body: " + body);
        }
    }
}

