/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.spi.RoutePolicy;

public class CustomRoutePolicyTest
extends ContextTestSupport {
    private final MyCustomRoutePolicy policy = new MyCustomRoutePolicy();

    public void testCustomPolicy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"stop"});
        this.template.sendBody("direct:foo", (Object)"stop");
        this.assertMockEndpointsSatisfied();
        CustomRoutePolicyTest.assertTrue((String)"Should be stopped", (boolean)this.policy.isStopped());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").routePolicy(new RoutePolicy[]{CustomRoutePolicyTest.this.policy}).to("mock:result");
            }
        };
    }

    private static class MyCustomRoutePolicy
    extends RoutePolicySupport {
        private volatile AtomicBoolean stopped = new AtomicBoolean();

        private MyCustomRoutePolicy() {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("stop".equals(body)) {
                try {
                    this.stopped.set(true);
                    this.stopConsumer(route.getConsumer());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        public boolean isStopped() {
            return this.stopped.get();
        }
    }
}

