/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class DeadLetterChannelBuilderWithInvalidDeadLetterUriTest
extends ContextTestSupport {
    public void testInvalidUri() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("xxx"));
                    this.from("direct:start").to("mock:foo");
                }
            });
            DeadLetterChannelBuilderWithInvalidDeadLetterUriTest.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchEndpointException e) {
            DeadLetterChannelBuilderWithInvalidDeadLetterUriTest.assertEquals((String)"No endpoint could be found for: xxx, please check your classpath contains the needed Camel component jar.", (String)e.getMessage());
        }
    }

    public void testInvalidOption() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("direct:error?foo=bar"));
                    this.from("direct:start").to("mock:foo");
                }
            });
            DeadLetterChannelBuilderWithInvalidDeadLetterUriTest.fail((String)"Should have thrown an exception");
        }
        catch (ResolveEndpointFailedException e) {
            DeadLetterChannelBuilderWithInvalidDeadLetterUriTest.assertTrue((boolean)e.getMessage().endsWith("Unknown parameters=[{foo=bar}]"));
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

