/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class DeadLetterChannelRedeliveringWhileShutdownTest
extends ContextTestSupport {
    public void testDLCRedelivery() throws Exception {
        long start = System.currentTimeMillis();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:damm", (Object)"Damn World");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        long delta = System.currentTimeMillis() - start;
        DeadLetterChannelRedeliveringWhileShutdownTest.assertTrue((String)("Should be faster than: " + delta), (delta < 4000L ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(2).redeliveryDelay(3000L));
                this.from("direct:start").delay(500L).to("mock:result");
                this.from("seda:damm").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Damn");
                    }
                });
            }
        };
    }
}

