/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;

public class DynamicRouter3Test
extends ContextTestSupport {
    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").dynamicRouter().method(DynamicRouter3Test.class, "slip");
            }
        };
    }

    public String slip(String body, @Header(value="CamelSlipEndpoint") String previous) {
        if (previous == null) {
            return "mock:a,mock:b";
        }
        if ("mock://b".equals(previous)) {
            return "mock:c";
        }
        return null;
    }
}

