/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Properties;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class DynamicRouterExchangePropertiesTest
extends ContextTestSupport {
    private static List<String> bodies = new ArrayList<String>();

    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedPropertyReceived("invoked", (Object)1);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedPropertyReceived("invoked", (Object)2);
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedPropertyReceived("invoked", (Object)2);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:foo").expectedPropertyReceived("invoked", (Object)3);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedPropertyReceived("invoked", (Object)4);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DynamicRouterExchangePropertiesTest.assertEquals((int)5, (int)bodies.size());
        DynamicRouterExchangePropertiesTest.assertEquals((String)"Hello World", (String)bodies.get(0));
        DynamicRouterExchangePropertiesTest.assertEquals((String)"Hello World", (String)bodies.get(1));
        DynamicRouterExchangePropertiesTest.assertEquals((String)"Hello World", (String)bodies.get(2));
        DynamicRouterExchangePropertiesTest.assertEquals((String)"Bye World", (String)bodies.get(3));
        DynamicRouterExchangePropertiesTest.assertEquals((String)"Bye World", (String)bodies.get(4));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").dynamicRouter((Expression)this.method(DynamicRouterExchangePropertiesTest.class, "slip"));
                ((RouteDefinition)this.from("direct:foo").transform((Expression)this.constant("Bye World"))).to("mock:foo");
            }
        };
    }

    public String slip(String body, @Properties Map<String, Object> properties) {
        bodies.add(body);
        int invoked = 0;
        Object current = properties.get("invoked");
        if (current != null) {
            invoked = Integer.valueOf(current.toString());
        }
        properties.put("invoked", ++invoked);
        if (invoked == 1) {
            return "mock:a";
        }
        if (invoked == 2) {
            return "mock:b,mock:c";
        }
        if (invoked == 3) {
            return "direct:foo";
        }
        if (invoked == 4) {
            return "mock:result";
        }
        return null;
    }
}

