/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class DynamicRouterTest
extends ContextTestSupport {
    private static int invoked;
    private static List<String> bodies;

    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DynamicRouterTest.assertEquals((int)5, (int)invoked);
        DynamicRouterTest.assertEquals((int)5, (int)bodies.size());
        DynamicRouterTest.assertEquals((String)"Hello World", (String)bodies.get(0));
        DynamicRouterTest.assertEquals((String)"Hello World", (String)bodies.get(1));
        DynamicRouterTest.assertEquals((String)"Hello World", (String)bodies.get(2));
        DynamicRouterTest.assertEquals((String)"Bye World", (String)bodies.get(3));
        DynamicRouterTest.assertEquals((String)"Bye World", (String)bodies.get(4));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").dynamicRouter((Expression)this.method(DynamicRouterTest.class, "slip"));
                ((RouteDefinition)this.from("direct:foo").transform((Expression)this.constant("Bye World"))).to("mock:foo");
            }
        };
    }

    public String slip(String body) {
        bodies.add(body);
        if (++invoked == 1) {
            return "mock:a";
        }
        if (invoked == 2) {
            return "mock:b,mock:c";
        }
        if (invoked == 3) {
            return "direct:foo";
        }
        if (invoked == 4) {
            return "mock:result";
        }
        return null;
    }

    static {
        bodies = new ArrayList<String>();
    }
}

