/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ErrorHandlerTest
extends ContextTestSupport {
    public void testNoError() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        error.expectedMessageCount(0);
        result.expectedMessageCount(1);
        result.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testError() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        error.expectedMessageCount(1);
        error.expectedBodiesReceived(new Object[]{"Boom"});
        result.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Boom");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(1).redeliveryDelay(0L)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Boom".equals(body)) {
                            throw new IllegalArgumentException("Forced exception by unit test");
                        }
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

