/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.spi.InterceptStrategy;

public class FaultRouteTest
extends ContextTestSupport {
    protected MockEndpoint a;
    protected MockEndpoint b;
    protected MockEndpoint c;
    protected MockEndpoint err;

    public void testWithOut() throws Exception {
        this.a.whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setBody((Object)"out");
            }
        });
        this.a.expectedMessageCount(1);
        this.b.expectedBodiesReceived(new Object[]{"out"});
        this.template.sendBody("direct:start", (Object)"in");
        this.assertMockEndpointsSatisfied();
    }

    public void testWithFault() throws Exception {
        this.a.whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setFault(true);
                exchange.getOut().setBody((Object)"fault");
            }
        });
        this.a.expectedMessageCount(1);
        this.b.expectedMessageCount(0);
        Exchange response = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"in");
            }
        });
        this.assertMockEndpointsSatisfied();
        FaultRouteTest.assertFalse((String)"Fault should be removed", (boolean)response.hasOut());
        FaultRouteTest.assertNotNull((String)"Should have exception", (Object)response.getException());
        FaultRouteTest.assertEquals((String)"fault", (String)response.getException().getMessage());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.resolveMandatoryEndpoint("mock:a", MockEndpoint.class);
        this.b = this.resolveMandatoryEndpoint("mock:b", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().addInterceptStrategy((InterceptStrategy)new HandleFault());
                ((RouteDefinition)this.from("direct:start").to("mock:a")).to("mock:b");
            }
        };
    }
}

