/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class FileIdempotentConsumerLoadStoreTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private File store = new File("target/idempotentfilestore.dat");
    private IdempotentRepository<String> repo;

    public void testLoadStore() throws Exception {
        FileIdempotentConsumerLoadStoreTest.assertFalse((boolean)this.repo.contains((Object)"1"));
        FileIdempotentConsumerLoadStoreTest.assertFalse((boolean)this.repo.contains((Object)"2"));
        FileIdempotentConsumerLoadStoreTest.assertFalse((boolean)this.repo.contains((Object)"3"));
        FileIdempotentConsumerLoadStoreTest.assertTrue((boolean)this.repo.contains((Object)"4"));
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("4", "four");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.resultEndpoint.assertIsSatisfied();
        FileIdempotentConsumerLoadStoreTest.assertTrue((boolean)this.repo.contains((Object)"1"));
        FileIdempotentConsumerLoadStoreTest.assertTrue((boolean)this.repo.contains((Object)"2"));
        FileIdempotentConsumerLoadStoreTest.assertTrue((boolean)this.repo.contains((Object)"3"));
        FileIdempotentConsumerLoadStoreTest.assertTrue((boolean)this.repo.contains((Object)"4"));
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        if (this.store.exists()) {
            this.store.delete();
        }
        FileOutputStream fos = new FileOutputStream(this.store);
        fos.write("4\n".getBytes());
        fos.close();
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)this.store);
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), FileIdempotentConsumerLoadStoreTest.this.repo).to("mock:result");
            }
        };
    }
}

