/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.MDC;

public class MDCTest
extends ContextTestSupport {
    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMDCTwoMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MDCTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-a", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        TestCase.assertEquals((String)exchange.getIn().getMessageId(), (String)MDC.get((String)"camel.messageId"));
                        MDC.put((String)"custom.id", (String)"1");
                    }
                })).to("log:foo")).to("direct:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-b", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        TestCase.assertEquals((String)exchange.getIn().getMessageId(), (String)MDC.get((String)"camel.messageId"));
                        TestCase.assertEquals((String)"1", (String)MDC.get((String)"custom.id"));
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }
}

