/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.MDC;

public class MDCWireTapTest
extends ContextTestSupport {
    public void testMDC() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MDCWireTapTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-a", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        MDC.put((String)"custom.id", (String)"1");
                    }
                })).to("log:before-wiretap")).wireTap("direct:b").delay(2000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-a", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        TestCase.assertEquals((String)"1", (String)MDC.get((String)"custom.id"));
                    }
                })).to("log:a-done")).to("mock:a");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-b", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        TestCase.assertEquals((String)"1", (String)MDC.get((String)"custom.id"));
                    }
                })).to("log:b-done")).to("mock:b");
            }
        };
    }
}

