/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class MulticastParallelMiddleTimeoutTest
extends ContextTestSupport {
    public void testMulticastParallelMiddleTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"AC"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().timeout(2000L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                this.from("direct:a").setBody((Expression)this.constant("A"));
                this.from("direct:b").delay(3000L).setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(500L).setBody((Expression)this.constant("C"));
            }
        };
    }
}

